/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CopyOnWriteHashMap<K, V>
extends AbstractMap<K, V>
implements Cloneable {
    private Map<K, V> map;
    private boolean writable = true;
    private transient Set<Map.Entry<K, V>> entrySet = null;

    public CopyOnWriteHashMap() {
        this.map = new HashMap();
    }

    public CopyOnWriteHashMap(int capacity) {
        this.map = new HashMap(capacity);
    }

    public CopyOnWriteHashMap(Map<K, V> map) {
        this.map = new HashMap<K, V>(map);
    }

    private void makeReadOnly() {
        this.writable = false;
    }

    private void makeWritable() {
        if (this.writable) {
            return;
        }
        this.map = this.copyMap(this.map);
        this.writable = true;
        this.entrySet = null;
    }

    protected Map<K, V> copyMap(Map<K, V> original) {
        return new HashMap<K, V>(original);
    }

    @Override
    public CopyOnWriteHashMap<K, V> clone() {
        try {
            CopyOnWriteHashMap clone = (CopyOnWriteHashMap)super.clone();
            this.makeReadOnly();
            clone.makeReadOnly();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public V put(K key, V value) {
        this.makeWritable();
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.makeWritable();
        return this.map.remove(key);
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, V>> mapIterator;

        public EntryIterator() {
            this.mapIterator = CopyOnWriteHashMap.this.map.entrySet().iterator();
        }

        @Override
        public final boolean hasNext() {
            return this.mapIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.mapIterator.next();
        }

        @Override
        public void remove() {
            if (!CopyOnWriteHashMap.this.writable) {
                throw new UnsupportedOperationException("Cannot perform the copy-on-write operation during iteration");
            }
            this.mapIterator.remove();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object candidate = CopyOnWriteHashMap.this.map.get(entry.getKey());
            if (candidate == null) {
                return entry.getValue() == null;
            }
            return candidate.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object o) {
            CopyOnWriteHashMap.this.makeWritable();
            return CopyOnWriteHashMap.this.map.remove(o) != null;
        }

        @Override
        public int size() {
            return CopyOnWriteHashMap.this.map.size();
        }

        @Override
        public void clear() {
            CopyOnWriteHashMap.this.map.clear();
        }
    }
}

