/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

final class BufferedInput {
    private final byte[] source;
    private final int end;
    private final int start;
    private int position;
    private String failReason;
    private int failPos;

    void fail(String reason) {
        if (this.failed()) {
            return;
        }
        this.failReason = reason;
        this.failPos = this.position;
        this.position = this.end;
    }

    public BufferedInput(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public BufferedInput(byte[] bytes, int offset, int length) {
        this.source = bytes;
        this.start = offset;
        this.position = offset;
        this.end = offset + length;
    }

    public final byte getByte() {
        if (this.position == this.end) {
            this.fail("underflow");
            return 0;
        }
        return this.source[this.position++];
    }

    public boolean failed() {
        return this.failReason != null;
    }

    public boolean eof() {
        return this.position == this.end;
    }

    public String getErrorMessage() {
        return this.failReason;
    }

    public int getConsumedSize() {
        return this.failed() ? 0 : this.position - this.start;
    }

    public byte[] getOffending() {
        byte[] ret = new byte[this.failPos - this.start];
        System.arraycopy(this.source, this.start, ret, 0, this.failPos - this.start);
        return ret;
    }

    public final byte[] getBacking() {
        return this.source;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void skip(int size) {
        if (this.position + size > this.end) {
            this.fail("underflow");
        } else {
            this.position += size;
        }
    }

    public final byte[] getBytes(int size) {
        if (this.position + size > this.end) {
            this.fail("underflow");
            return new byte[0];
        }
        byte[] ret = new byte[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.source[this.position++];
        }
        return ret;
    }
}

