/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class TeeInputStream
extends InputStream {
    final InputStream src;
    final OutputStream dst;
    static final int CAPACITY = 65536;
    byte[] buf = new byte[65536];
    int readPos = 0;
    int writePos = 0;

    private int inBuf() {
        return this.writePos - this.readPos;
    }

    private void fillBuf() throws IOException {
        int got;
        if (this.readPos == this.writePos) {
            this.readPos = 0;
            this.writePos = 0;
        }
        if (this.readPos * 3 > 65536) {
            int had = this.inBuf();
            System.arraycopy(this.buf, this.readPos, this.buf, 0, had);
            this.readPos = 0;
            this.writePos = had;
        }
        int wantToRead = 65536 - this.writePos;
        if (this.inBuf() > 0) {
            wantToRead = Math.min(wantToRead, this.src.available());
        }
        if (wantToRead > 0 && (got = this.src.read(this.buf, this.writePos, wantToRead)) > 0) {
            this.dst.write(this.buf, this.writePos, got);
            this.writePos += got;
        }
    }

    public TeeInputStream(InputStream from, OutputStream to) {
        this.src = from;
        this.dst = to;
    }

    @Override
    public int available() throws IOException {
        return this.inBuf() + this.src.available();
    }

    @Override
    public void close() throws IOException {
        this.src.close();
        this.dst.close();
    }

    @Override
    public int read() throws IOException {
        this.fillBuf();
        if (this.inBuf() > 0) {
            byte r = this.buf[this.readPos++];
            return r & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        this.fillBuf();
        int had = this.inBuf();
        if (had > 0) {
            len = Math.min(len, had);
            System.arraycopy(this.buf, this.readPos, b, off, len);
            this.readPos += len;
            return len;
        }
        return -1;
    }
}

