/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import com.yahoo.io.Acceptor;
import com.yahoo.io.Connection;
import com.yahoo.io.ConnectionFactory;
import com.yahoo.io.FatalErrorHandler;
import com.yahoo.io.SelectLoopHook;
import com.yahoo.io.UpdateInterest;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Listener
extends Thread {
    private static Logger log = Logger.getLogger(Listener.class.getName());
    private Selector selector;
    Map<Integer, Acceptor> acceptors = new HashMap<Integer, Acceptor>();
    Map<ServerSocketChannel, ConnectionFactory> factories = new IdentityHashMap<ServerSocketChannel, ConnectionFactory>();
    private FatalErrorHandler fatalErrorHandler;
    private List<SelectLoopHook> selectLoopPreHooks;
    private List<SelectLoopHook> selectLoopPostHooks;
    private final LinkedList<Connection> newConnections = new LinkedList();
    private final LinkedList<UpdateInterest> modifyInterestOpsQueue = new LinkedList();

    public Listener(String name) {
        super("Listener-" + name);
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.fine(name + " listener created " + this);
    }

    public synchronized void setFatalErrorHandler(FatalErrorHandler f) {
        this.fatalErrorHandler = f;
    }

    public void addSelectLoopPreHook(SelectLoopHook hook) {
        if (this.selectLoopPreHooks == null) {
            this.selectLoopPreHooks = new ArrayList<SelectLoopHook>(5);
        }
        this.selectLoopPreHooks.add(hook);
    }

    public void addSelectLoopPostHook(SelectLoopHook hook) {
        if (this.selectLoopPostHooks == null) {
            this.selectLoopPostHooks = new ArrayList<SelectLoopHook>(5);
        }
        this.selectLoopPostHooks.add(hook);
    }

    private void runSelectLoopPreHooks() {
        if (this.selectLoopPreHooks == null) {
            return;
        }
        for (SelectLoopHook hook : this.selectLoopPreHooks) {
            hook.selectLoopHook(true);
        }
    }

    private void runSelectLoopPostHooks() {
        if (this.selectLoopPostHooks == null) {
            return;
        }
        for (SelectLoopHook hook : this.selectLoopPostHooks) {
            hook.selectLoopHook(false);
        }
    }

    public synchronized void listen(ConnectionFactory factory, int port) throws IOException {
        if (this.acceptors.containsKey(port)) {
            log.warning("Already listening to port=" + port);
            return;
        }
        Acceptor a = new Acceptor(this, factory, port);
        if (this.fatalErrorHandler != null) {
            a.setFatalErrorHandler(this.fatalErrorHandler);
        }
        a.listen().start();
        this.acceptors.put(port, a);
    }

    public synchronized void listenNoAcceptor(ConnectionFactory factory, int port) throws IOException {
        ServerSocketChannel s = ServerSocketChannel.open();
        s.configureBlocking(false);
        s.socket().setReuseAddress(true);
        s.socket().bind(new InetSocketAddress(port));
        String host = s.socket().getInetAddress().getHostName();
        this.factories.put(s, factory);
        s.register(this.selector, 16);
        log.fine("listener " + host + ":" + port);
    }

    public Listener modifyInterestOps(Connection connection, int op, boolean set) {
        return this.modifyInterestOps(connection.socketChannel().keyFor(this.selector), op, set);
    }

    public Listener modifyInterestOpsBatch(Connection connection, int op, boolean set) {
        return this.modifyInterestOpsBatch(connection.socketChannel().keyFor(this.selector), op, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Listener modifyInterestOps(SelectionKey key, int op, boolean set) {
        LinkedList<UpdateInterest> linkedList = this.modifyInterestOpsQueue;
        synchronized (linkedList) {
            this.modifyInterestOpsQueue.addLast(new UpdateInterest(key, op, set));
        }
        this.selector.wakeup();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Listener modifyInterestOpsBatch(SelectionKey key, int op, boolean set) {
        LinkedList<UpdateInterest> linkedList = this.modifyInterestOpsQueue;
        synchronized (linkedList) {
            this.modifyInterestOpsQueue.addLast(new UpdateInterest(key, op, set));
        }
        return this;
    }

    public Listener modifyInterestOpsDone() {
        this.selector.wakeup();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processModifyInterestOps() {
        LinkedList<UpdateInterest> linkedList = this.modifyInterestOpsQueue;
        synchronized (linkedList) {
            while (!this.modifyInterestOpsQueue.isEmpty()) {
                UpdateInterest u = this.modifyInterestOpsQueue.removeFirst();
                u.doUpdate();
            }
        }
    }

    @Override
    public void run() {
        block2: {
            log.fine("Started listener");
            try {
                this.selectLoop();
            }
            catch (Throwable t) {
                if (this.fatalErrorHandler == null) break block2;
                this.fatalErrorHandler.handle(t, null);
            }
        }
    }

    private void selectLoop() {
        while (!Thread.currentThread().isInterrupted()) {
            this.processNewConnections();
            this.processModifyInterestOps();
            try {
                int n = this.selector.select();
                if (0 == n) {
                    continue;
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "error during select", e);
                return;
            }
            this.runSelectLoopPreHooks();
            Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
            while (i.hasNext()) {
                SelectionKey key = i.next();
                i.remove();
                if (!key.isValid()) continue;
                if (key.isReadable()) {
                    this.performRead(key);
                    if (!key.isValid()) continue;
                }
                if (key.isWritable()) {
                    this.performWrite(key);
                    if (!key.isValid()) continue;
                }
                if (key.isConnectable()) {
                    this.performConnect(key);
                    if (!key.isValid()) continue;
                }
                if (!key.isAcceptable()) continue;
                this.performAccept(key);
            }
            this.runSelectLoopPostHooks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection addNewConnection(Connection newConn) {
        SocketChannel channel = newConn.socketChannel();
        if (channel.isBlocking()) {
            try {
                channel.configureBlocking(false);
            }
            catch (IllegalBlockingModeException e) {
                log.log(Level.SEVERE, "Unable to set nonblocking", e);
                try {
                    channel.close();
                }
                catch (IOException ee) {
                    log.log(Level.WARNING, "channel close failed", ee);
                }
                return newConn;
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Unable to set nonblocking", e);
                return newConn;
            }
        }
        LinkedList<Connection> linkedList = this.newConnections;
        synchronized (linkedList) {
            this.newConnections.addLast(newConn);
        }
        this.selector.wakeup();
        return newConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processNewConnections() {
        LinkedList<Connection> linkedList = this.newConnections;
        synchronized (linkedList) {
            while (!this.newConnections.isEmpty()) {
                Connection conn = this.newConnections.removeFirst();
                try {
                    conn.socketChannel().register(this.selector, conn.selectOps(), conn);
                }
                catch (ClosedChannelException e) {
                    log.log(Level.WARNING, "register channel failed", e);
                    return;
                }
            }
        }
    }

    private void performAccept(SelectionKey key) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        while (true) {
            SocketChannel channel;
            ServerSocketChannel ssChannel;
            try {
                ssChannel = (ServerSocketChannel)key.channel();
                channel = ssChannel.accept();
                if (null == channel) {
                    return;
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "accept failed", e);
                return;
            }
            try {
                channel.configureBlocking(false);
            }
            catch (IllegalBlockingModeException e) {
                log.log(Level.SEVERE, "Unable to set nonblocking", e);
                try {
                    channel.close();
                }
                catch (IOException ee) {
                    log.log(Level.WARNING, "channel close failed", ee);
                }
                continue;
            }
            catch (IOException e) {
                log.log(Level.WARNING, "IO error occurred", e);
                try {
                    channel.close();
                }
                catch (IOException ee) {
                    log.log(Level.WARNING, "channel close failed", ee);
                }
                continue;
            }
            ConnectionFactory factory = this.factories.get(ssChannel);
            Connection conn = factory.newConnection(channel, this);
            try {
                channel.register(this.selector, conn.selectOps(), conn);
                continue;
            }
            catch (ClosedChannelException e) {
                log.log(Level.WARNING, "register channel failed", e);
                continue;
            }
            break;
        }
    }

    private void performConnect(SelectionKey key) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Connection c = (Connection)key.attachment();
        try {
            c.connect();
        }
        catch (IOException e) {
            log.log(Level.FINE, "connect failed", e);
            try {
                c.close();
            }
            catch (IOException e2) {
                log.log(Level.FINE, "close failed", e);
            }
        }
    }

    private void performRead(SelectionKey key) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Connection c = (Connection)key.attachment();
        try {
            c.read();
        }
        catch (IOException e) {
            log.log(Level.FINE, "read failed", e);
            try {
                c.close();
            }
            catch (IOException e2) {
                log.log(Level.FINE, "close failed", e);
            }
        }
    }

    private void performWrite(SelectionKey key) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Connection c = (Connection)key.attachment();
        try {
            c.write();
        }
        catch (IOException e) {
            log.log(Level.FINE, " write failed", e);
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnection(Connection connection) {
        LinkedList<Connection> linkedList = this.newConnections;
        synchronized (linkedList) {
            this.newConnections.addLast(connection);
        }
        this.selector.wakeup();
    }

    public void shutdown() {
    }
}

