/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.net;

import com.yahoo.text.Lowercase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class URI
implements Cloneable,
Serializable,
Comparable<URI> {
    private static final long serialVersionUID = 2271558213498856909L;
    private String uri;
    private String scheme = null;
    private String host = null;
    private int port = -1;
    private String rest = null;
    private static final Pattern tokenizePattern = Pattern.compile("[^\\w\\-]");
    private boolean parsedDomain = false;
    private String domain = null;
    private boolean parsedMainTld = false;
    private String mainTld = null;
    private boolean parsedPath = false;
    private String path = null;
    private boolean parsedParams = false;
    private String params = null;
    private boolean parsedFilename = false;
    private String filename = null;
    private boolean parsedExtension = false;
    private String extension = null;
    private boolean parsedQuery = false;
    private String query = null;
    private boolean parsedFragment = false;
    private String fragment = null;
    private String invalidExplanation = null;
    private boolean opaque = true;

    public URI(String uriString) {
        this(uriString, false);
    }

    public URI(String uriString, boolean keepFragment) {
        this(uriString, keepFragment, false);
    }

    public URI(String uriString, boolean keepFragment, boolean hierarchicalOnly) {
        int fragmentIndex;
        if (uriString == null) {
            throw new NullPointerException("Can not create an uri from null");
        }
        if (!keepFragment && (fragmentIndex = uriString.indexOf("#")) >= 0) {
            uriString = uriString.substring(0, fragmentIndex);
        }
        try {
            this.uri = uriString.trim();
            this.opaque = this.isOpaque(this.uri);
            if (this.isOpaque() && !hierarchicalOnly) {
                return;
            }
            this.opaque = false;
            this.normalizeHierarchical();
        }
        catch (IllegalArgumentException e) {
            Throwable t;
            this.invalidExplanation = e.getMessage() != null ? e.getMessage() : ((t = e.getCause()) != null && t.getMessage() != null ? t.getMessage() : "Invalid uri: " + e);
        }
    }

    public URI(String scheme, String host, int port, String rest) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.rest = rest;
        this.recombine();
        this.normalizeHierarchical();
        this.opaque = false;
    }

    private boolean isOpaque(String uri) {
        int colonIndex = uri.indexOf(":");
        if (colonIndex < 0) {
            return true;
        }
        return uri.length() <= colonIndex + 1 || uri.charAt(colonIndex + 1) != '/';
    }

    public boolean isValid() {
        return this.invalidExplanation == null;
    }

    private void normalizeHierarchical() {
        this.complete();
        this.escapeNonAscii();
        this.unescapeHtmlEntities();
        this.decompose();
        this.lowCaseHost();
        this.removeDefaultPortNumber();
        this.removeTrailingHostDot();
        this.makeDoubleSlashesSingle();
        this.recombine();
    }

    private void complete() {
        if (this.uri.startsWith("www.")) {
            this.uri = "http://" + this.uri;
        } else if (this.uri.startsWith("WWW")) {
            this.uri = "http://" + this.uri;
        } else if (this.uri.startsWith("/http:")) {
            this.uri = this.uri.substring(1);
        } else if (this.isFileURIShortHand(this.uri)) {
            this.uri = "file://" + this.uri;
        }
    }

    private boolean isFileURIShortHand(String uri) {
        if (uri.indexOf(":\\") == 1) {
            return true;
        }
        if (uri.indexOf("c:/") == 0) {
            return true;
        }
        return uri.indexOf("d:/") == 0;
    }

    private void decompose() {
        java.net.URI neturi = java.net.URI.create(this.uri).normalize();
        this.scheme = neturi.getScheme();
        this.host = neturi.getHost();
        boolean portAlreadyParsed = false;
        if (this.host == null) {
            this.host = neturi.getAuthority();
            if (this.host != null) {
                int colonPos = this.host.lastIndexOf(":");
                if (!this.scheme.equals("file") && colonPos > -1) {
                    try {
                        this.port = Integer.parseInt(this.host.substring(colonPos + 1, this.host.length()));
                        this.host = this.host.substring(0, colonPos);
                        portAlreadyParsed = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if ("file".equalsIgnoreCase(this.scheme)) {
            this.host = this.host == null ? "localhost" : this.repairWindowsDrive(this.host, this.uri);
        }
        if (this.host == null) {
            throw new IllegalArgumentException("A complete uri must specify a host");
        }
        if (!portAlreadyParsed) {
            this.port = neturi.getPort();
        }
        this.rest = (neturi.getRawPath() != null ? neturi.getRawPath() : "") + (String)(neturi.getRawQuery() != null ? "?" + neturi.getRawQuery() : "") + (String)(neturi.getRawFragment() != null ? "#" + neturi.getRawFragment() : "");
    }

    private String repairWindowsDrive(String host, String uri) {
        if (host.length() != 1) {
            return host;
        }
        int driveIndex = uri.indexOf(host + ":");
        if (driveIndex == 5 || driveIndex == 7) {
            return host + ":";
        }
        return host;
    }

    private void escapeNonAscii() {
        char[] uriChars = this.uri.toCharArray();
        StringBuilder result = new StringBuilder(this.uri.length());
        for (char uriChar : uriChars) {
            if (uriChar >= '\u0080' || uriChar == '\"') {
                result.append("%");
                result.append(Integer.toHexString(uriChar));
                result.append(";");
                continue;
            }
            result.append(uriChar);
        }
        this.uri = result.toString();
    }

    private void unescapeHtmlEntities() {
        int ampIndex = this.uri.indexOf("&amp;");
        if (ampIndex < 0) {
            return;
        }
        StringBuilder result = new StringBuilder(this.uri.substring(0, ampIndex));
        while (ampIndex >= 0) {
            result.append("&");
            int nextAmpIndex = this.uri.indexOf("&amp;", ampIndex + 5);
            result.append(this.uri.substring(ampIndex + 5, nextAmpIndex > 0 ? nextAmpIndex : this.uri.length()));
            ampIndex = nextAmpIndex;
        }
        this.uri = result.toString();
    }

    private void lowCaseHost() {
        this.host = Lowercase.toLowerCase(this.host);
    }

    private void removeDefaultPortNumber() {
        if (this.port == 80 && this.scheme.equals("http")) {
            this.port = -1;
        } else if (this.port == 443 && this.scheme.equals("https")) {
            this.port = -1;
        }
    }

    private void removeTrailingHostDot() {
        if (this.host.endsWith(".")) {
            this.host = this.host.substring(0, this.host.length() - 1);
        }
    }

    private void makeDoubleSlashesSingle() {
        StringBuilder result = new StringBuilder(this.rest.length());
        char[] restChars = this.rest.toCharArray();
        for (int i = 0; i < restChars.length; ++i) {
            if (i + 1 < restChars.length && restChars[i] == '/' && restChars[i + 1] == '/') continue;
            result.append(restChars[i]);
        }
        this.rest = result.toString();
    }

    private void recombine() {
        StringBuilder recombined = new StringBuilder(100);
        recombined.append(this.scheme);
        recombined.append("://");
        recombined.append(this.host);
        if (this.port > -1) {
            recombined.append(":").append(this.port);
        }
        if (this.rest != null) {
            if (!this.rest.startsWith("/")) {
                recombined.append("/");
            }
            recombined.append(this.rest);
        } else {
            recombined.append("/");
        }
        this.uri = recombined.toString();
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRest() {
        if (this.rest == null) {
            return null;
        }
        if (this.rest.equals("/")) {
            return "";
        }
        return this.rest;
    }

    public String getDomain() {
        if (this.parsedDomain) {
            return this.domain;
        }
        String host = this.getHost();
        if (host == null) {
            return null;
        }
        int firstDotPos = host.indexOf(".");
        int lastDotPos = host.lastIndexOf(".");
        String domain = firstDotPos < 0 ? host : (firstDotPos == lastDotPos ? host : host.substring(firstDotPos + 1, host.length()));
        this.parsedDomain = true;
        this.domain = domain;
        return domain;
    }

    public String getMainTld() {
        if (this.parsedMainTld) {
            return this.mainTld;
        }
        String host = this.getHost();
        if (host == null) {
            return null;
        }
        int lastDotPos = host.lastIndexOf(".");
        String mainTld = lastDotPos < 0 ? null : (lastDotPos == host.length() - 1 ? null : host.substring(lastDotPos + 1, host.length()));
        this.parsedMainTld = true;
        this.mainTld = mainTld;
        return mainTld;
    }

    public String getPath() {
        if (this.parsedPath) {
            return this.path;
        }
        String rest = this.rest;
        if (rest == null) {
            return null;
        }
        int queryPos = (rest = this.removeFragment(rest)).lastIndexOf("?");
        if (queryPos > -1) {
            rest = rest.substring(0, queryPos);
        }
        this.parsedPath = true;
        this.path = rest;
        return this.path;
    }

    private String removeFragment(String path) {
        int fragmentPos = path.lastIndexOf("#");
        return fragmentPos > -1 ? path.substring(0, fragmentPos) : path;
    }

    public String getFilename() {
        if (this.parsedFilename) {
            return this.filename;
        }
        String path = this.getPath();
        if (path == null) {
            return null;
        }
        int lastSlash = (path = this.removeParams(path)).lastIndexOf("/");
        String filename = lastSlash < 0 ? path : (lastSlash == path.length() - 1 ? "" : path.substring(lastSlash + 1, path.length()));
        this.parsedFilename = true;
        this.filename = filename;
        return filename;
    }

    private String removeParams(String filename) {
        int firstSemicolon = filename.indexOf(";");
        if (firstSemicolon < 0) {
            return filename;
        }
        return filename.substring(0, firstSemicolon);
    }

    public String getExtension() {
        if (this.parsedExtension) {
            return this.extension;
        }
        String filename = this.getFilename();
        if (filename == null) {
            return null;
        }
        int lastDotPos = filename.lastIndexOf(".");
        String extension = lastDotPos < 0 ? null : (lastDotPos == filename.length() - 1 ? null : filename.substring(lastDotPos + 1, filename.length()));
        this.parsedExtension = true;
        this.extension = extension;
        return extension;
    }

    public String getQuery() {
        if (this.parsedQuery) {
            return this.query;
        }
        String rest = this.rest;
        if (rest == null) {
            return null;
        }
        rest = this.removeFragment(rest);
        int queryPos = rest.lastIndexOf("?");
        String query = null;
        if (queryPos > -1) {
            query = rest.substring(queryPos + 1, rest.length());
        }
        this.parsedQuery = true;
        this.query = query;
        return query;
    }

    public String getFragment() {
        if (this.parsedFragment) {
            return this.fragment;
        }
        String path = this.rest;
        if (path == null) {
            return null;
        }
        int fragmentPos = path.lastIndexOf("#");
        String fragment = null;
        if (fragmentPos > -1) {
            fragment = path.substring(fragmentPos + 1, path.length());
        }
        this.parsedFragment = true;
        this.fragment = fragment;
        return fragment;
    }

    public String getParams() {
        if (this.parsedParams) {
            return this.params;
        }
        String path = this.getPath();
        if (path == null) {
            return null;
        }
        int semicolonPos = path.indexOf(";");
        String params = semicolonPos < 0 ? null : (semicolonPos == path.length() - 1 ? null : path.substring(semicolonPos + 1, path.length()));
        this.parsedParams = true;
        this.params = params;
        return params;
    }

    public static String[] tokenize(String item) {
        return tokenizePattern.split(item);
    }

    public List<Token> tokenize() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        tokens.addAll(this.tokenize(URLContext.URL_SCHEME, this.getScheme()));
        tokens.addAll(this.tokenize(URLContext.URL_HOST, this.getHost()));
        tokens.addAll(this.tokenize(URLContext.URL_PORT, this.getPort() > -1 ? "" + this.getPort() : null));
        tokens.addAll(this.tokenize(URLContext.URL_PATH, this.getPath()));
        tokens.addAll(this.tokenize(URLContext.URL_QUERY, this.getQuery()));
        tokens.addAll(this.tokenize(URLContext.URL_FRAGMENT, this.getFragment()));
        return tokens;
    }

    private List<Token> tokenize(URLContext context, String item) {
        if (item == null) {
            return new ArrayList<Token>(0);
        }
        String[] tokenStrings = URI.tokenize(item);
        ArrayList<Token> tokens = new ArrayList<Token>(tokenStrings.length);
        for (String tokenString : tokenStrings) {
            if (tokenString.length() <= 0) continue;
            tokens.add(new Token(context, tokenString));
        }
        return tokens;
    }

    public String getInvalidExplanation() {
        return this.invalidExplanation;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof URI)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    @Override
    public int compareTo(URI object) {
        return this.toString().compareTo(object.toString());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Someone made me unclonable!", e);
        }
    }

    public URI setScheme(String scheme) {
        return new URI(scheme, this.host, this.port, this.rest);
    }

    public URI setHost(String host) {
        return new URI(this.scheme, host, this.port, this.rest);
    }

    public URI setPort(int port) {
        return new URI(this.scheme, this.host, port, this.rest);
    }

    public URI setRest(String rest) {
        return new URI(this.scheme, this.host, this.port, rest);
    }

    public URI addParameter(String name, String value) {
        Object newRest = this.rest;
        if (newRest == null) {
            newRest = "";
        }
        newRest = ((String)newRest).indexOf("?") < 0 ? (String)newRest + "?" : (String)newRest + "&";
        newRest = (String)newRest + name + "=" + value;
        return new URI(this.scheme, this.host, this.port, (String)newRest);
    }

    public String stringValue() {
        return this.uri;
    }

    public String toString() {
        return this.uri;
    }

    public int getDepth() {
        int colonIndex;
        int currentIndex = colonIndex = this.uri.indexOf(58);
        int depth = 0;
        while (currentIndex != -1) {
            if ((currentIndex = this.uri.indexOf(47, currentIndex)) == -1) continue;
            ++depth;
            ++currentIndex;
        }
        if (this.uri.charAt(colonIndex + 1) == '/') {
            --depth;
        }
        if (this.uri.charAt(colonIndex + 2) == '/') {
            --depth;
        }
        if (this.uri.charAt(this.uri.length() - 1) == '/' && this.uri.length() - 1 > colonIndex + 2) {
            --depth;
        }
        return depth;
    }

    public static enum URLContext {
        URL_SCHEME(0, "scheme"),
        URL_HOST(1, "host"),
        URL_DOMAIN(2, "domain"),
        URL_MAINTLD(3, "maintld"),
        URL_PORT(4, "port"),
        URL_PATH(5, "path"),
        URL_FILENAME(6, "filename"),
        URL_EXTENSION(7, "extension"),
        URL_PARAMS(8, "params"),
        URL_QUERY(9, "query"),
        URL_FRAGMENT(10, "fragment");

        public final int id;
        public final String name;

        private URLContext(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static class Token {
        private final URLContext context;
        private final String token;

        private Token(URLContext context, String token) {
            this.context = context;
            this.token = token;
        }

        public URLContext getContext() {
            return this.context;
        }

        public String getToken() {
            return this.token;
        }
    }
}

