/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import java.util.Map;

public final class JSON {
    private JSON() {
    }

    public static String encode(Map<String, ?> map) {
        StringBuilder b = new StringBuilder("{");
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            b.append("\"").append(JSON.escape(entry.getKey())).append("\":");
            if (entry.getValue() instanceof String) {
                b.append("\"").append(JSON.escape(entry.getValue().toString())).append("\"");
            } else {
                b.append(entry.getValue());
            }
            b.append(",");
        }
        if (b.length() > 1) {
            b.setLength(b.length() - 1);
        }
        b.append("}");
        return b.toString();
    }

    public static String escape(String s) {
        StringBuilder b = null;
        int i = 0;
        while (i < s.length()) {
            int codepoint = s.codePointAt(i);
            if (codepoint == 34) {
                if (b == null) {
                    b = new StringBuilder(s.substring(0, i));
                }
                b.append('\\');
            }
            if (b != null) {
                b.appendCodePoint(codepoint);
            }
            i = s.offsetByCodePoints(i, 1);
        }
        return b != null ? b.toString() : s;
    }

    public static boolean equals(String left, String right) {
        Slime leftSlime = SlimeUtils.jsonToSlimeOrThrow(left);
        Slime rightSlime = SlimeUtils.jsonToSlimeOrThrow(right);
        return leftSlime.equalTo(rightSlime);
    }
}

