/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

public class ExpressionFormatter {
    private static final int indentUnit = 2;
    private final int firstColumnLength;
    private final int secondColumnLength;

    private ExpressionFormatter(int firstColumnLength, int secondColumnLength) {
        this.firstColumnLength = firstColumnLength;
        this.secondColumnLength = secondColumnLength;
    }

    public String format(String parenthesisExpression) {
        StringBuilder b = new StringBuilder();
        this.format(parenthesisExpression, 0, b);
        while (b.length() > 0 && Character.isWhitespace(b.charAt(b.length() - 1))) {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    private void format(String expression, int indent, StringBuilder b) {
        if (expression.isEmpty()) {
            return;
        }
        Markup next = Markup.next(expression = this.appendFirstColumn(expression, b));
        this.appendIndent(!next.isClose() || next.position() > 0 ? indent : indent - 2, b);
        int endOfBalancedChunk = this.endOfBalancedChunk(expression, Math.max(0, this.secondColumnLength - indent));
        if (next.isEmpty()) {
            b.append(expression);
        } else if (endOfBalancedChunk > 0) {
            b.append(expression, 0, endOfBalancedChunk + 1).append("\n");
            this.format(expression.substring(endOfBalancedChunk + 1), indent, b);
        } else if (next.isComma()) {
            b.append(expression, 0, next.position() + 1).append("\n");
            this.format(expression.substring(next.position() + 1), indent, b);
        } else {
            if (next.isClose() && next.position() > 0) {
                b.append(expression, 0, next.position()).append("\n");
                this.appendFirstColumn(")", b);
                this.appendIndent(indent - 2, b);
                b.append(")\n");
            } else {
                b.append(expression, 0, next.position() + 1).append("\n");
            }
            this.format(expression.substring(next.position() + 1), indent + (next.isOpen() ? 2 : -2), b);
        }
    }

    private int endOfBalancedChunk(String expression, int maxSize) {
        int chunkSize = 0;
        int nesting = 0;
        for (int i = 0; i < maxSize && i < expression.length(); ++i) {
            if (expression.charAt(i) == '\t') {
                return chunkSize;
            }
            if (expression.charAt(i) == '(') {
                ++nesting;
            }
            if (expression.charAt(i) == ')') {
                --nesting;
            }
            if (nesting < 0) {
                return chunkSize;
            }
            if (nesting != 0 || expression.charAt(i) != ')' && expression.charAt(i) != ',') continue;
            chunkSize = i;
        }
        return chunkSize;
    }

    private String appendFirstColumn(String expression, StringBuilder b) {
        int tab2;
        if (this.firstColumnLength == 0) {
            return expression;
        }
        while (expression.charAt(0) == ' ') {
            expression = expression.substring(1);
        }
        if (expression.charAt(0) == '\t' && (tab2 = expression.indexOf(9, 1)) >= 0) {
            String firstColumn = expression.substring(1, tab2);
            b.append(this.asSize(this.firstColumnLength, firstColumn)).append(" ");
            return expression.substring(tab2 + 1);
        }
        this.appendIndent(this.firstColumnLength + 1, b);
        return expression;
    }

    private void appendIndent(int indent, StringBuilder b) {
        b.append(" ".repeat(Math.max(0, indent)));
    }

    private String asSize(int size, String s) {
        if (s.length() > size) {
            return s.substring(0, size);
        }
        return s + " ".repeat(size - s.length());
    }

    public static String on(String parenthesisExpression) {
        return new ExpressionFormatter(0, 80).format(parenthesisExpression);
    }

    public static ExpressionFormatter withLineLength(int maxLineLength) {
        return new ExpressionFormatter(0, maxLineLength);
    }

    public static ExpressionFormatter inTwoColumnMode(int firstColumnSize, int secondColumnSize) {
        return new ExpressionFormatter(firstColumnSize, secondColumnSize);
    }

    private static class Markup {
        final int open;
        final int close;
        final int comma;

        private Markup(int open, int close, int comma) {
            this.open = open;
            this.close = close;
            this.comma = comma;
        }

        int position() {
            return Math.min(Math.min(this.open, this.close), this.comma);
        }

        boolean isOpen() {
            return this.open < this.close && this.open < this.comma;
        }

        boolean isClose() {
            return this.close < this.open && this.close < this.comma;
        }

        boolean isComma() {
            return this.comma < this.open && this.comma < this.close;
        }

        boolean isEmpty() {
            return this.open == Integer.MAX_VALUE && this.close == Integer.MAX_VALUE && this.comma == Integer.MAX_VALUE;
        }

        static Markup next(String expression) {
            int nextOpen = expression.indexOf(40);
            int nextClose = expression.indexOf(41);
            int nextComma = expression.indexOf(44);
            if (nextOpen < 0) {
                nextOpen = Integer.MAX_VALUE;
            }
            if (nextClose < 0) {
                nextClose = Integer.MAX_VALUE;
            }
            if (nextComma < 0) {
                nextComma = Integer.MAX_VALUE;
            }
            return new Markup(nextOpen, nextClose, nextComma);
        }
    }
}

