/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.EvaluationContext;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;

public class Map<NAMETYPE extends Name>
extends PrimitiveTensorFunction<NAMETYPE> {
    private final TensorFunction<NAMETYPE> argument;
    private final DoubleUnaryOperator mapper;

    public Map(TensorFunction<NAMETYPE> argument, DoubleUnaryOperator mapper) {
        Objects.requireNonNull(argument, "The argument tensor cannot be null");
        Objects.requireNonNull(mapper, "The argument function cannot be null");
        this.argument = argument;
        this.mapper = mapper;
    }

    public static TensorType outputType(TensorType inputType) {
        return inputType;
    }

    public TensorFunction<NAMETYPE> argument() {
        return this.argument;
    }

    public DoubleUnaryOperator mapper() {
        return this.mapper;
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return Collections.singletonList(this.argument);
    }

    @Override
    public TensorFunction<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Map must have 1 argument, got " + arguments.size());
        }
        return new Map<NAMETYPE>(arguments.get(0), this.mapper);
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        return new Map<NAMETYPE>(this.argument.toPrimitive(), this.mapper);
    }

    @Override
    public TensorType type(TypeContext<NAMETYPE> context) {
        return this.argument.type(context);
    }

    @Override
    public Tensor evaluate(EvaluationContext<NAMETYPE> context) {
        Tensor argument = this.argument().evaluate(context);
        Tensor.Builder builder = Tensor.Builder.of(argument.type());
        Iterator<Tensor.Cell> i = argument.cellIterator();
        while (i.hasNext()) {
            Map.Entry cell = i.next();
            builder.cell((TensorAddress)cell.getKey(), this.mapper.applyAsDouble((Double)cell.getValue()));
        }
        return builder.build();
    }

    @Override
    public String toString(ToStringContext context) {
        return "map(" + this.argument.toString(context) + ", " + this.mapper + ")";
    }
}

