/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.slime.Type;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class SlimeUtils {
    public static void copyObject(Inspector from, Cursor to) {
        if (from.type() != Type.OBJECT) {
            throw new IllegalArgumentException("Cannot copy object: " + from);
        }
        from.traverse((name, inspector) -> SlimeUtils.setObjectEntry(inspector, name, to));
    }

    private static void setObjectEntry(Inspector from, String name, Cursor to) {
        switch (from.type()) {
            case NIX: {
                to.setNix(name);
                break;
            }
            case BOOL: {
                to.setBool(name, from.asBool());
                break;
            }
            case LONG: {
                to.setLong(name, from.asLong());
                break;
            }
            case DOUBLE: {
                to.setDouble(name, from.asDouble());
                break;
            }
            case STRING: {
                to.setString(name, from.asString());
                break;
            }
            case DATA: {
                to.setData(name, from.asData());
                break;
            }
            case ARRAY: {
                Cursor array = to.setArray(name);
                SlimeUtils.copyArray(from, array);
                break;
            }
            case OBJECT: {
                Cursor object = to.setObject(name);
                SlimeUtils.copyObject(from, object);
            }
        }
    }

    private static void copyArray(Inspector from, Cursor to) {
        from.traverse((i, inspector) -> SlimeUtils.addValue(inspector, to));
    }

    private static void addValue(Inspector from, Cursor to) {
        switch (from.type()) {
            case NIX: {
                to.addNix();
                break;
            }
            case BOOL: {
                to.addBool(from.asBool());
                break;
            }
            case LONG: {
                to.addLong(from.asLong());
                break;
            }
            case DOUBLE: {
                to.addDouble(from.asDouble());
                break;
            }
            case STRING: {
                to.addString(from.asString());
                break;
            }
            case DATA: {
                to.addData(from.asData());
                break;
            }
            case ARRAY: {
                Cursor array = to.addArray();
                SlimeUtils.copyArray(from, array);
                break;
            }
            case OBJECT: {
                Cursor object = to.addObject();
                SlimeUtils.copyObject(from, object);
            }
        }
    }

    public static byte[] toJsonBytes(Slime slime) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new JsonFormat(true).encode((OutputStream)baos, slime);
        return baos.toByteArray();
    }

    public static Slime jsonToSlime(byte[] json) {
        Slime slime = new Slime();
        new JsonDecoder().decode(slime, json);
        return slime;
    }

    public static Slime jsonToSlime(String json) {
        return SlimeUtils.jsonToSlime(json.getBytes(StandardCharsets.UTF_8));
    }

    public static Optional<String> optionalString(Inspector inspector) {
        return Optional.of(inspector.asString()).filter(s -> !s.isEmpty());
    }
}

