/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.data.access.slime;

import com.yahoo.data.access.ArrayTraverser;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.ObjectTraverser;
import com.yahoo.data.access.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;

public final class SlimeAdapter
implements Inspector {
    private com.yahoo.slime.Inspector inspector;

    public SlimeAdapter(com.yahoo.slime.Inspector inspector) {
        this.inspector = inspector;
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof SlimeAdapter)) {
            return false;
        }
        return this.inspector.equals(((SlimeAdapter)rhs).inspector);
    }

    public int hashCode() {
        return this.inspector.hashCode();
    }

    public String toString() {
        return this.inspector.toString();
    }

    @Override
    public Inspector inspect() {
        return this;
    }

    @Override
    public boolean valid() {
        return this.inspector.valid();
    }

    @Override
    public Type type() {
        switch (this.inspector.type()) {
            case NIX: {
                return Type.EMPTY;
            }
            case BOOL: {
                return Type.BOOL;
            }
            case LONG: {
                return Type.LONG;
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case STRING: {
                return Type.STRING;
            }
            case DATA: {
                return Type.DATA;
            }
            case ARRAY: {
                return Type.ARRAY;
            }
            case OBJECT: {
                return Type.OBJECT;
            }
        }
        return Type.EMPTY;
    }

    private boolean verify(com.yahoo.slime.Type ok_type_a) {
        com.yahoo.slime.Type my_type = this.inspector.type();
        return this.valid() && my_type == ok_type_a;
    }

    private boolean verify(com.yahoo.slime.Type ok_type_a, com.yahoo.slime.Type ok_type_b) {
        com.yahoo.slime.Type my_type = this.inspector.type();
        return this.valid() && (my_type == ok_type_a || my_type == ok_type_b);
    }

    private boolean verify(com.yahoo.slime.Type ok_type_a, com.yahoo.slime.Type ok_type_b, com.yahoo.slime.Type ok_type_c) {
        com.yahoo.slime.Type my_type = this.inspector.type();
        return this.valid() && (my_type == ok_type_a || my_type == ok_type_b || my_type == ok_type_c);
    }

    @Override
    public int entryCount() {
        return this.inspector.entries();
    }

    @Override
    public int fieldCount() {
        return this.inspector.fields();
    }

    @Override
    public boolean asBool() {
        if (!this.verify(com.yahoo.slime.Type.NIX, com.yahoo.slime.Type.BOOL)) {
            throw new IllegalStateException("invalid data extraction!");
        }
        return this.inspector.asBool();
    }

    @Override
    public long asLong() {
        if (!this.verify(com.yahoo.slime.Type.NIX, com.yahoo.slime.Type.LONG, com.yahoo.slime.Type.DOUBLE)) {
            throw new IllegalStateException("invalid data extraction!");
        }
        return this.inspector.asLong();
    }

    @Override
    public double asDouble() {
        if (!this.verify(com.yahoo.slime.Type.NIX, com.yahoo.slime.Type.DOUBLE, com.yahoo.slime.Type.LONG)) {
            throw new IllegalStateException("invalid data extraction!");
        }
        return this.inspector.asDouble();
    }

    @Override
    public String asString() {
        if (!this.verify(com.yahoo.slime.Type.NIX, com.yahoo.slime.Type.STRING)) {
            throw new IllegalStateException("invalid data extraction!");
        }
        return this.inspector.asString();
    }

    @Override
    public byte[] asUtf8() {
        if (!this.verify(com.yahoo.slime.Type.NIX, com.yahoo.slime.Type.STRING)) {
            throw new IllegalStateException("invalid data extraction!");
        }
        return this.inspector.asUtf8();
    }

    @Override
    public byte[] asData() {
        if (!this.verify(com.yahoo.slime.Type.NIX, com.yahoo.slime.Type.DATA)) {
            throw new IllegalStateException("invalid data extraction!");
        }
        return this.inspector.asData();
    }

    @Override
    public boolean asBool(boolean defaultValue) {
        if (!this.verify(com.yahoo.slime.Type.BOOL)) {
            return defaultValue;
        }
        return this.inspector.asBool();
    }

    @Override
    public long asLong(long defaultValue) {
        if (!this.verify(com.yahoo.slime.Type.LONG, com.yahoo.slime.Type.DOUBLE)) {
            return defaultValue;
        }
        return this.inspector.asLong();
    }

    @Override
    public double asDouble(double defaultValue) {
        if (!this.verify(com.yahoo.slime.Type.DOUBLE, com.yahoo.slime.Type.LONG)) {
            return defaultValue;
        }
        return this.inspector.asDouble();
    }

    @Override
    public String asString(String defaultValue) {
        if (!this.verify(com.yahoo.slime.Type.STRING)) {
            return defaultValue;
        }
        return this.inspector.asString();
    }

    @Override
    public byte[] asUtf8(byte[] defaultValue) {
        if (!this.verify(com.yahoo.slime.Type.STRING)) {
            return defaultValue;
        }
        return this.inspector.asUtf8();
    }

    @Override
    public byte[] asData(byte[] defaultValue) {
        if (!this.verify(com.yahoo.slime.Type.DATA)) {
            return defaultValue;
        }
        return this.inspector.asData();
    }

    @Override
    public void traverse(final ArrayTraverser at) {
        this.inspector.traverse(new com.yahoo.slime.ArrayTraverser(){

            @Override
            public void entry(int idx, com.yahoo.slime.Inspector inspector) {
                at.entry(idx, new SlimeAdapter(inspector));
            }
        });
    }

    @Override
    public void traverse(final ObjectTraverser ot) {
        this.inspector.traverse(new com.yahoo.slime.ObjectTraverser(){

            @Override
            public void field(String name, com.yahoo.slime.Inspector inspector) {
                ot.field(name, new SlimeAdapter(inspector));
            }
        });
    }

    @Override
    public Inspector entry(int idx) {
        return new SlimeAdapter(this.inspector.entry(idx));
    }

    @Override
    public Inspector field(String name) {
        return new SlimeAdapter(this.inspector.field(name));
    }

    @Override
    public Iterable<Inspector> entries() {
        final ArrayList<Inspector> list = new ArrayList<Inspector>();
        this.inspector.traverse(new com.yahoo.slime.ArrayTraverser(){

            @Override
            public void entry(int idx, com.yahoo.slime.Inspector inspector) {
                list.add(new SlimeAdapter(inspector));
            }
        });
        return list;
    }

    @Override
    public Iterable<Map.Entry<String, Inspector>> fields() {
        final ArrayList<Map.Entry<String, Inspector>> list = new ArrayList<Map.Entry<String, Inspector>>();
        this.inspector.traverse(new com.yahoo.slime.ObjectTraverser(){

            @Override
            public void field(String name, com.yahoo.slime.Inspector inspector) {
                list.add(new AbstractMap.SimpleImmutableEntry<String, SlimeAdapter>(name, new SlimeAdapter(inspector)));
            }
        });
        return list;
    }
}

