/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListMap<K, V> {
    private boolean frozen = false;
    private Map<K, List<V>> map;

    public ListMap() {
        this(HashMap.class);
    }

    public ListMap(ListMap<K, V> original) {
        this.map = new HashMap<K, List<V>>();
        original.map.forEach((k, v) -> this.map.put(k, new ArrayList(v)));
    }

    public ListMap(Class<? extends Map> implementation) {
        try {
            this.map = implementation.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void put(K key, V value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
        list.add(value);
    }

    public void put(K key) {
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
    }

    public void replace(K key, V value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            this.put(key);
        } else {
            list.clear();
            list.add(value);
        }
    }

    public void removeAll(K key) {
        this.map.remove(key);
    }

    public boolean removeValue(K key, V value) {
        List<V> list = this.map.get(key);
        if (list != null) {
            return list.remove(value);
        }
        return false;
    }

    public V removeValue(K key, int index) {
        List<V> list = this.map.get(key);
        if (list != null) {
            return list.remove(index);
        }
        throw new IndexOutOfBoundsException("The list at '" + key + "' is empty");
    }

    public List<V> get(K key) {
        List<V> list = this.map.get(key);
        if (list == null) {
            return ImmutableList.of();
        }
        return list;
    }

    public List<V> getList(K key) {
        return this.get(key);
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<List<V>> values() {
        return this.map.values();
    }

    public void freeze() {
        if (this.frozen) {
            return;
        }
        for (Map.Entry<K, List<ImmutableList>> entry : this.map.entrySet()) {
            entry.setValue((List<ImmutableList>)ImmutableList.copyOf((Collection)entry.getValue()));
        }
        this.map = ImmutableMap.copyOf(this.map);
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public String toString() {
        return "ListMap{frozen=" + this.frozen + ", map=" + this.map + "}";
    }

    public int size() {
        return this.map.size();
    }
}

