/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.DimensionSizes;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.Arrays;

class IndexedDoubleTensor
extends IndexedTensor {
    private final double[] values;

    IndexedDoubleTensor(TensorType type, DimensionSizes dimensionSizes, double[] values) {
        super(type, dimensionSizes);
        this.values = values;
    }

    @Override
    public long size() {
        return this.values.length;
    }

    @Override
    public double get(long valueIndex) {
        return this.values[(int)valueIndex];
    }

    @Override
    public float getFloat(long valueIndex) {
        return (float)this.get(valueIndex);
    }

    @Override
    public IndexedTensor withType(TensorType type) {
        this.throwOnIncompatibleType(type);
        return new IndexedDoubleTensor(type, this.dimensionSizes(), this.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public static class BoundDoubleBuilder
    extends IndexedTensor.BoundBuilder {
        private double[] values;

        BoundDoubleBuilder(TensorType type, DimensionSizes sizes) {
            this(type, sizes, new double[(int)sizes.totalSize()]);
        }

        BoundDoubleBuilder(TensorType type, DimensionSizes sizes, double[] values) {
            super(type, sizes);
            this.values = values;
        }

        @Override
        public IndexedTensor.BoundBuilder cell(float value, long ... indexes) {
            return this.cell((double)value, indexes);
        }

        @Override
        public IndexedTensor.BoundBuilder cell(double value, long ... indexes) {
            this.values[(int)IndexedTensor.toValueIndex((long[])indexes, (DimensionSizes)this.sizes())] = value;
            return this;
        }

        @Override
        public Tensor.Builder.CellBuilder cell() {
            return new Tensor.Builder.CellBuilder(this.type, this);
        }

        @Override
        public IndexedTensor.Builder cell(TensorAddress address, float value) {
            return this.cell(address, (double)value);
        }

        @Override
        public IndexedTensor.Builder cell(TensorAddress address, double value) {
            this.values[(int)IndexedTensor.toValueIndex((TensorAddress)address, (DimensionSizes)this.sizes(), (TensorType)this.type)] = value;
            return this;
        }

        @Override
        public IndexedTensor build() {
            IndexedDoubleTensor tensor = new IndexedDoubleTensor(this.type, this.sizes(), this.values);
            this.values = null;
            return tensor;
        }

        @Override
        public IndexedTensor.Builder cell(Tensor.Cell cell, float value) {
            return this.cell(cell, (double)value);
        }

        @Override
        public IndexedTensor.Builder cell(Tensor.Cell cell, double value) {
            long directIndex = cell.getDirectIndex();
            if (directIndex >= 0L) {
                this.values[(int)directIndex] = value;
            } else {
                super.cell(cell, value);
            }
            return this;
        }

        @Override
        public void cellByDirectIndex(long index, float value) {
            this.cellByDirectIndex(index, (double)value);
        }

        @Override
        public void cellByDirectIndex(long index, double value) {
            try {
                this.values[(int)index] = value;
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Can not set the cell at position " + index + " in a tensor of type " + this.type + ": Index is too large");
            }
        }
    }
}

