/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.system.execution;

import com.yahoo.system.execution.ProcessResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;

public class ProcessExecutor {
    public final int timeoutSeconds;
    private final int[] successExitCodes;

    private ProcessExecutor(int timeoutSeconds, int[] successExitCodes) {
        this.timeoutSeconds = timeoutSeconds;
        this.successExitCodes = successExitCodes;
    }

    public Optional<ProcessResult> execute(String command) throws IOException {
        return this.execute(command, null);
    }

    public Optional<ProcessResult> execute(String command, String processInput) throws IOException {
        int exitCode;
        ByteArrayOutputStream processErr = new ByteArrayOutputStream();
        ByteArrayOutputStream processOut = new ByteArrayOutputStream();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)ProcessExecutor.createStreamHandler(processOut, processErr, processInput));
        ExecuteWatchdog watchDog = new ExecuteWatchdog(TimeUnit.SECONDS.toMillis(this.timeoutSeconds));
        executor.setWatchdog(watchDog);
        executor.setExitValues(this.successExitCodes);
        try {
            exitCode = executor.execute(CommandLine.parse((String)command));
        }
        catch (ExecuteException e) {
            exitCode = e.getExitValue();
        }
        return watchDog.killedProcess() ? Optional.empty() : Optional.of(new ProcessResult(exitCode, processOut.toString(), processErr.toString()));
    }

    private static PumpStreamHandler createStreamHandler(ByteArrayOutputStream processOut, ByteArrayOutputStream processErr, String input) {
        if (input != null) {
            ByteArrayInputStream processInput = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
            return new PumpStreamHandler((OutputStream)processOut, (OutputStream)processErr, (InputStream)processInput);
        }
        return new PumpStreamHandler((OutputStream)processOut, (OutputStream)processErr);
    }

    public static class Builder {
        private final int timeoutSeconds;
        private int[] successExitCodes;

        public Builder(int timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        public Builder successExitCodes(int ... successExitCodes) {
            this.successExitCodes = successExitCodes;
            return this;
        }

        public ProcessExecutor build() {
            return new ProcessExecutor(this.timeoutSeconds, this.successExitCodes);
        }
    }
}

