/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.osgi.maven;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ProjectBundleClassPaths {
    public static final String CLASSPATH_MAPPINGS_FILENAME = "bundle-plugin.bundle-classpath-mappings.json";
    public final BundleClasspathMapping mainBundle;
    public final List<BundleClasspathMapping> providedDependencies;

    public ProjectBundleClassPaths(BundleClasspathMapping mainBundle, List<BundleClasspathMapping> providedDependencies) {
        this.mainBundle = mainBundle;
        this.providedDependencies = providedDependencies;
    }

    public static void save(Path path, ProjectBundleClassPaths mappings) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            ProjectBundleClassPaths.save(out, mappings);
        }
    }

    static void save(OutputStream out, ProjectBundleClassPaths mappings) throws IOException {
        Slime slime = new Slime();
        Cursor rootCursor = slime.setObject();
        Cursor mainBundleCursor = rootCursor.setObject("mainBundle");
        BundleClasspathMapping.save(mainBundleCursor, mappings.mainBundle);
        Cursor dependenciesCursor = rootCursor.setArray("providedDependencies");
        mappings.providedDependencies.forEach(d -> BundleClasspathMapping.save(dependenciesCursor.addObject(), d));
        new JsonFormat(false).encode(out, slime);
    }

    public static ProjectBundleClassPaths load(Path path) throws IOException {
        byte[] bytes = Files.readAllBytes(path);
        return ProjectBundleClassPaths.load(bytes);
    }

    static ProjectBundleClassPaths load(byte[] bytes) {
        Slime slime = new Slime();
        new JsonDecoder().decode(slime, bytes);
        Cursor inspector = slime.get();
        BundleClasspathMapping mainBundle = BundleClasspathMapping.load(inspector.field("mainBundle"));
        Inspector dependenciesInspector = inspector.field("providedDependencies");
        ArrayList<BundleClasspathMapping> providedDependencies = new ArrayList<BundleClasspathMapping>();
        for (int i = 0; i < dependenciesInspector.entries(); ++i) {
            providedDependencies.add(BundleClasspathMapping.load(dependenciesInspector.entry(i)));
        }
        return new ProjectBundleClassPaths(mainBundle, providedDependencies);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectBundleClassPaths that = (ProjectBundleClassPaths)o;
        return Objects.equals(this.mainBundle, that.mainBundle) && Objects.equals(this.providedDependencies, that.providedDependencies);
    }

    public int hashCode() {
        return Objects.hash(this.mainBundle, this.providedDependencies);
    }

    public static class BundleClasspathMapping {
        public final String bundleSymbolicName;
        public final List<String> classPathElements;

        public BundleClasspathMapping(String bundleSymbolicName, List<String> classPathElements) {
            this.bundleSymbolicName = bundleSymbolicName;
            this.classPathElements = classPathElements;
        }

        static void save(Cursor rootCursor, BundleClasspathMapping mapping) {
            rootCursor.setString("bundleSymbolicName", mapping.bundleSymbolicName);
            Cursor arrayCursor = rootCursor.setArray("classPathElements");
            mapping.classPathElements.forEach(arrayCursor::addString);
        }

        static BundleClasspathMapping load(Inspector inspector) {
            String bundleSymoblicName = inspector.field("bundleSymbolicName").asString();
            Inspector elementsInspector = inspector.field("classPathElements");
            ArrayList<String> classPathElements = new ArrayList<String>();
            for (int i = 0; i < elementsInspector.entries(); ++i) {
                classPathElements.add(elementsInspector.entry(i).asString());
            }
            return new BundleClasspathMapping(bundleSymoblicName, classPathElements);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BundleClasspathMapping that = (BundleClasspathMapping)o;
            return Objects.equals(this.bundleSymbolicName, that.bundleSymbolicName) && Objects.equals(this.classPathElements, that.classPathElements);
        }

        public int hashCode() {
            return Objects.hash(this.bundleSymbolicName, this.classPathElements);
        }
    }
}

