/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import com.yahoo.io.AbstractByteWriter;
import com.yahoo.text.Utf8;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetEncoder;

public class ByteWriter
extends AbstractByteWriter {
    private final OutputStream stream;

    public ByteWriter(OutputStream stream, CharsetEncoder encoder) {
        super(encoder);
        this.stream = stream;
    }

    public ByteWriter(OutputStream stream) {
        super(Utf8.getNewEncoder());
        this.stream = stream;
    }

    @Override
    public void send(ByteBuffer b) throws IOException {
        this.stream.write(b.array(), b.position() + b.arrayOffset(), b.limit() - b.position());
    }

    @Override
    public void close() throws IOException {
        this.buffer.flush();
        this.stream.close();
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }
}

