/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import com.yahoo.io.ConnectionFactory;
import com.yahoo.io.FatalErrorHandler;
import com.yahoo.io.Listener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Acceptor
extends Thread {
    private static Logger log = Logger.getLogger(Acceptor.class.getName());
    private int port;
    ServerSocketChannel socket;
    private Listener listener;
    private boolean initialized = false;
    private ConnectionFactory factory;
    private FatalErrorHandler fatalErrorHandler;

    public Acceptor(Listener listener, ConnectionFactory factory, int port) {
        super("Acceptor-" + listener.getName() + "-" + port);
        this.listener = listener;
        this.factory = factory;
        this.port = port;
    }

    public Acceptor listen() throws IOException {
        this.socket = ServerSocketChannel.open();
        this.socket.configureBlocking(true);
        this.socket.socket().setReuseAddress(true);
        this.socket.socket().bind(new InetSocketAddress(this.port));
        this.initialized = true;
        return this;
    }

    public synchronized void setFatalErrorHandler(FatalErrorHandler f) {
        this.fatalErrorHandler = f;
    }

    @Override
    public void run() {
        block11: {
            try {
                log.fine("Acceptor thread started");
                if (!this.initialized) {
                    log.severe("Acceptor was not initialized.  aborting");
                    return;
                }
                while (!this.isInterrupted()) {
                    SocketChannel c = null;
                    try {
                        c = this.socket.accept();
                        c.configureBlocking(false);
                        this.listener.addNewConnection(this.factory.newConnection(c, this.listener));
                    }
                    catch (IllegalBlockingModeException e) {
                        log.log(Level.SEVERE, "Unable to set nonblocking", e);
                        try {
                            if (c == null) continue;
                            c.close();
                        }
                        catch (IOException iOException) {
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Error accepting connection on port=" + this.port, e);
                        try {
                            if (c == null) continue;
                            c.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Throwable t) {
                if (this.fatalErrorHandler == null) break block11;
                this.fatalErrorHandler.handle(t, null);
            }
        }
    }
}

