/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class DaemonThreadFactory
implements ThreadFactory {
    private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
    private String prefix = null;

    public DaemonThreadFactory() {
    }

    public DaemonThreadFactory(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t = this.defaultThreadFactory.newThread(runnable);
        t.setDaemon(true);
        if (this.prefix != null) {
            t.setName(this.prefix + t.getName());
        }
        return t;
    }
}

