/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.compress;

import com.yahoo.compress.CompressionType;
import java.util.Arrays;
import java.util.Optional;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;

public class Compressor {
    private final CompressionType type;
    private final int level;
    private final double compressionThresholdFactor;
    private final int compressMinSizeBytes;
    private final LZ4Factory factory = LZ4Factory.fastestInstance();

    public Compressor() {
        this(CompressionType.LZ4);
    }

    public Compressor(CompressionType type) {
        this(type, 9, 0.95, 0);
    }

    public Compressor(CompressionType type, int level, double compressionThresholdFactor, int compressMinSizeBytes) {
        this.type = type;
        this.level = level;
        this.compressionThresholdFactor = compressionThresholdFactor;
        this.compressMinSizeBytes = compressMinSizeBytes;
    }

    public CompressionType type() {
        return this.type;
    }

    public int level() {
        return this.level;
    }

    public double compressionThresholdFactor() {
        return this.compressionThresholdFactor;
    }

    public int compressMinSizeBytes() {
        return this.compressMinSizeBytes;
    }

    public Compression compress(CompressionType requestedCompression, byte[] data, Optional<Integer> uncompressedSize) {
        switch (requestedCompression) {
            case NONE: {
                data = uncompressedSize.isPresent() ? Arrays.copyOf(data, (int)uncompressedSize.get()) : data;
                return new Compression(CompressionType.NONE, data.length, data);
            }
            case LZ4: {
                int dataSize;
                int n = dataSize = uncompressedSize.isPresent() ? uncompressedSize.get() : data.length;
                if (dataSize < this.compressMinSizeBytes) {
                    return new Compression(CompressionType.INCOMPRESSIBLE, dataSize, data);
                }
                LZ4Compressor compressor = this.level < 7 ? this.factory.fastCompressor() : this.factory.highCompressor();
                byte[] compressedData = compressor.compress(data, 0, dataSize);
                if ((double)(compressedData.length + 8) >= (double)dataSize * this.compressionThresholdFactor) {
                    return new Compression(CompressionType.INCOMPRESSIBLE, dataSize, data);
                }
                return new Compression(CompressionType.LZ4, dataSize, compressedData);
            }
        }
        throw new IllegalArgumentException(requestedCompression + " is not supported");
    }

    public Compression compress(CompressionType requestedCompression, byte[] data) {
        return this.compress(requestedCompression, data, Optional.empty());
    }

    public Compression compress(byte[] data, int uncompressedSize) {
        return this.compress(this.type, data, Optional.of(uncompressedSize));
    }

    public Compression compress(byte[] data) {
        return this.compress(this.type, data, Optional.empty());
    }

    public byte[] decompress(CompressionType compression, byte[] compressedData, int compressedDataOffset, int expectedUncompressedSize, Optional<Integer> expectedCompressedSize) {
        switch (compression) {
            case NONE: 
            case INCOMPRESSIBLE: {
                int endPosition = expectedCompressedSize.isPresent() ? compressedDataOffset + expectedCompressedSize.get() : compressedData.length;
                return Arrays.copyOfRange(compressedData, compressedDataOffset, endPosition);
            }
            case LZ4: {
                byte[] uncompressedLZ4Data = new byte[expectedUncompressedSize];
                int compressedSize = this.factory.fastDecompressor().decompress(compressedData, compressedDataOffset, uncompressedLZ4Data, 0, expectedUncompressedSize);
                if (expectedCompressedSize.isPresent() && compressedSize != expectedCompressedSize.get()) {
                    throw new IllegalStateException("Compressed size mismatch. Expected " + compressedSize + ". Got " + expectedCompressedSize.get());
                }
                return uncompressedLZ4Data;
            }
        }
        throw new IllegalArgumentException(compression + " is not supported");
    }

    public byte[] decompress(byte[] compressedData, CompressionType compressionType, int uncompressedSize) {
        return this.decompress(compressionType, compressedData, 0, uncompressedSize, Optional.empty());
    }

    public byte[] decompress(Compression compression) {
        return this.decompress(compression.type(), compression.data(), 0, compression.uncompressedSize(), Optional.empty());
    }

    public static class Compression {
        private final CompressionType compressionType;
        private final int uncompressedSize;
        private final byte[] data;

        public Compression(CompressionType compressionType, int uncompressedSize, byte[] data) {
            this.compressionType = compressionType;
            this.uncompressedSize = uncompressedSize;
            this.data = data;
        }

        public CompressionType type() {
            return this.compressionType;
        }

        public int uncompressedSize() {
            return this.uncompressedSize;
        }

        public byte[] data() {
            return this.data;
        }
    }
}

