/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.google.common.collect.ImmutableList;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.CompositeTensorFunction;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.Map;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.List;

public class Softmax
extends CompositeTensorFunction {
    private final TensorFunction argument;
    private final String dimension;

    public Softmax(TensorFunction argument, String dimension) {
        this.argument = argument;
        this.dimension = dimension;
    }

    public static TensorType outputType(TensorType inputType, String dimension) {
        return Reduce.outputType(inputType, (List<String>)ImmutableList.of((Object)dimension));
    }

    @Override
    public List<TensorFunction> arguments() {
        return Collections.singletonList(this.argument);
    }

    @Override
    public TensorFunction withArguments(List<TensorFunction> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Softmax must have 1 argument, got " + arguments.size());
        }
        return new Softmax(arguments.get(0), this.dimension);
    }

    @Override
    public PrimitiveTensorFunction toPrimitive() {
        PrimitiveTensorFunction primitiveArgument = this.argument.toPrimitive();
        return new Join(new Map(primitiveArgument, ScalarFunctions.exp()), new Reduce((TensorFunction)new Map(primitiveArgument, ScalarFunctions.exp()), Reduce.Aggregator.sum, this.dimension), ScalarFunctions.divide());
    }

    @Override
    public String toString(ToStringContext context) {
        return "softmax(" + this.argument.toString(context) + ", " + this.dimension + ")";
    }
}

