/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.google.common.collect.ImmutableList;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.EvaluationContext;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Rename
extends PrimitiveTensorFunction {
    private final TensorFunction argument;
    private final List<String> fromDimensions;
    private final List<String> toDimensions;
    private final Map<String, String> fromToMap;

    public Rename(TensorFunction argument, String fromDimension, String toDimension) {
        this(argument, (List<String>)ImmutableList.of((Object)fromDimension), (List<String>)ImmutableList.of((Object)toDimension));
    }

    public Rename(TensorFunction argument, List<String> fromDimensions, List<String> toDimensions) {
        Objects.requireNonNull(argument, "The argument tensor cannot be null");
        Objects.requireNonNull(fromDimensions, "The 'from' dimensions cannot be null");
        Objects.requireNonNull(toDimensions, "The 'to' dimensions cannot be null");
        if (fromDimensions.size() < 1) {
            throw new IllegalArgumentException("from dimensions is empty, must rename at least one dimension");
        }
        if (fromDimensions.size() != toDimensions.size()) {
            throw new IllegalArgumentException("Rename from and to dimensions must be equal, was " + fromDimensions.size() + " and " + toDimensions.size());
        }
        this.argument = argument;
        this.fromDimensions = ImmutableList.copyOf(fromDimensions);
        this.toDimensions = ImmutableList.copyOf(toDimensions);
        this.fromToMap = Rename.fromToMap(fromDimensions, toDimensions);
    }

    public List<String> fromDimensions() {
        return this.fromDimensions;
    }

    public List<String> toDimensions() {
        return this.toDimensions;
    }

    private static Map<String, String> fromToMap(List<String> fromDimensions, List<String> toDimensions) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < fromDimensions.size(); ++i) {
            map.put(fromDimensions.get(i), toDimensions.get(i));
        }
        return map;
    }

    @Override
    public List<TensorFunction> arguments() {
        return Collections.singletonList(this.argument);
    }

    @Override
    public TensorFunction withArguments(List<TensorFunction> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Rename must have 1 argument, got " + arguments.size());
        }
        return new Rename(arguments.get(0), this.fromDimensions, this.toDimensions);
    }

    @Override
    public PrimitiveTensorFunction toPrimitive() {
        return this;
    }

    @Override
    public <NAMETYPE extends TypeContext.Name> TensorType type(TypeContext<NAMETYPE> context) {
        return this.type(this.argument.type(context));
    }

    private TensorType type(TensorType type) {
        TensorType.Builder builder = new TensorType.Builder();
        for (TensorType.Dimension dimension : type.dimensions()) {
            builder.dimension(dimension.withName(this.fromToMap.getOrDefault(dimension.name(), dimension.name())));
        }
        return builder.build();
    }

    @Override
    public <NAMETYPE extends TypeContext.Name> Tensor evaluate(EvaluationContext<NAMETYPE> context) {
        Tensor tensor = this.argument.evaluate(context);
        TensorType renamedType = this.type(tensor.type());
        int[] toIndexes = new int[tensor.type().dimensions().size()];
        for (int i = 0; i < tensor.type().dimensions().size(); ++i) {
            String dimensionName = tensor.type().dimensions().get(i).name();
            String newDimensionName = this.fromToMap.getOrDefault(dimensionName, dimensionName);
            toIndexes[i] = renamedType.indexOfDimension(newDimensionName).get();
        }
        if (this.simpleRenameIsPossible(toIndexes)) {
            return tensor.withType(renamedType);
        }
        Tensor.Builder builder = Tensor.Builder.of(renamedType);
        Iterator<Tensor.Cell> i = tensor.cellIterator();
        while (i.hasNext()) {
            Map.Entry cell = i.next();
            TensorAddress renamedAddress = this.rename((TensorAddress)cell.getKey(), toIndexes);
            builder.cell(renamedAddress, (double)((Double)cell.getValue()));
        }
        return builder.build();
    }

    private boolean simpleRenameIsPossible(int[] toIndexes) {
        for (int i = 0; i < toIndexes.length; ++i) {
            if (toIndexes[i] == i) continue;
            return false;
        }
        return true;
    }

    private TensorAddress rename(TensorAddress address, int[] toIndexes) {
        String[] reorderedLabels = new String[toIndexes.length];
        for (int i = 0; i < toIndexes.length; ++i) {
            reorderedLabels[toIndexes[i]] = address.label(i);
        }
        return TensorAddress.of(reorderedLabels);
    }

    @Override
    public String toString(ToStringContext context) {
        return "rename(" + this.argument.toString(context) + ", " + this.toVectorString(this.fromDimensions) + ", " + this.toVectorString(this.toDimensions) + ")";
    }

    private String toVectorString(List<String> elements) {
        if (elements.size() == 1) {
            return elements.get(0);
        }
        StringBuilder b = new StringBuilder("(");
        for (String element : elements) {
            b.append(element).append(", ");
        }
        b.setLength(b.length() - 2);
        b.append(")");
        return b.toString();
    }
}

