/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.javacc;

import java.io.IOException;

public class FastCharStream {
    private static final String JAVACC_EXCEPTION_FORMAT = "line -1, column ";
    private static final IOException EOF = new IOException();
    private final String inputStr;
    private final char[] inputArr;
    private int tokenPos = 0;
    private int readPos = 0;
    private int tabSize = 1;
    private boolean trackLineColumn = true;

    public FastCharStream(String input) {
        this.inputStr = input;
        this.inputArr = input.toCharArray();
    }

    public char readChar() throws IOException {
        if (this.readPos >= this.inputArr.length) {
            throw EOF;
        }
        return this.inputArr[this.readPos++];
    }

    public int getEndColumn() {
        return this.readPos + 1;
    }

    public int getEndLine() {
        return -1;
    }

    public int getBeginColumn() {
        return this.tokenPos + 1;
    }

    public int getBeginLine() {
        return -1;
    }

    public void backup(int amount) {
        this.readPos -= amount;
    }

    public char beginToken() throws IOException {
        this.tokenPos = this.readPos;
        return this.readChar();
    }

    public String getImage() {
        return this.inputStr.substring(this.tokenPos, this.readPos);
    }

    public char[] getSuffix(int len) {
        throw new UnsupportedOperationException();
    }

    public void done() {
    }

    public void setTabSize(int i) {
        this.tabSize = i;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTrackLineColumn(boolean tlc) {
        this.trackLineColumn = tlc;
    }

    public boolean isTrackLineColumn() {
        return this.trackLineColumn;
    }

    public String formatException(String parseException) {
        int errPos = FastCharStream.findErrPos(parseException);
        if (errPos < 0 || errPos > this.inputArr.length + 1) {
            return parseException;
        }
        int errLine = 0;
        int errColumn = 0;
        for (int i = 0; i < errPos - 1; ++i) {
            if (this.inputStr.charAt(i) == '\n') {
                ++errLine;
                errColumn = 0;
                continue;
            }
            ++errColumn;
        }
        StringBuilder out = new StringBuilder();
        out.append(parseException.replace(JAVACC_EXCEPTION_FORMAT + errPos, "line " + (errLine + 1) + ", column " + (errColumn + 1)));
        out.append("\nAt position:\n");
        this.appendErrorPosition(errLine, out);
        for (int i = 0; i < errColumn; ++i) {
            out.append(" ");
        }
        out.append("^");
        return out.toString();
    }

    private void appendErrorPosition(int errLine, StringBuilder out) {
        String[] inputStrLines = this.inputStr.split("\n");
        if (inputStrLines.length < errLine + 1) {
            out.append("EOF\n");
        } else {
            out.append(inputStrLines[errLine]).append("\n");
        }
    }

    private static int findErrPos(String str) {
        int to;
        int from = str.indexOf(JAVACC_EXCEPTION_FORMAT);
        if (from < 0) {
            return -1;
        }
        for (to = from += JAVACC_EXCEPTION_FORMAT.length(); to < str.length() && Character.isDigit(str.charAt(to)); ++to) {
        }
        if (to == from) {
            return -1;
        }
        return Integer.valueOf(str.substring(from, to));
    }
}

