/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.data.access.simple;

import com.yahoo.data.access.ArrayTraverser;
import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.ObjectTraverser;

public final class JsonRender {
    public static StringBuilder render(Inspectable value, StringBuilder target, boolean compact) {
        StringEncoder enc = new StringEncoder(target, compact);
        enc.encode(value.inspect());
        return target;
    }

    public static final class StringEncoder
    implements ArrayTraverser,
    ObjectTraverser {
        private final StringBuilder out;
        private boolean head = true;
        private boolean compact;
        private int level = 0;
        static final char[] hex = "0123456789ABCDEF".toCharArray();

        public StringEncoder(StringBuilder out, boolean compact) {
            this.out = out;
            this.compact = compact;
        }

        public void encode(Inspector top) {
            this.encodeValue(top);
            if (!this.compact) {
                this.out.append('\n');
            }
        }

        private void encodeEMPTY() {
            this.out.append("null");
        }

        private void encodeBOOL(boolean value) {
            this.out.append(value ? "true" : "false");
        }

        private void encodeLONG(long value) {
            this.out.append(String.valueOf(value));
        }

        private void encodeDOUBLE(double value) {
            if (Double.isFinite(value)) {
                this.out.append(String.valueOf(value));
            } else {
                this.out.append("null");
            }
        }

        private void encodeSTRING(String value) {
            this.out.append('\"');
            block9: for (char c : value.toCharArray()) {
                switch (c) {
                    case '\"': {
                        this.out.append('\\').append('\"');
                        continue block9;
                    }
                    case '\\': {
                        this.out.append('\\').append('\\');
                        continue block9;
                    }
                    case '\b': {
                        this.out.append('\\').append('b');
                        continue block9;
                    }
                    case '\f': {
                        this.out.append('\\').append('f');
                        continue block9;
                    }
                    case '\n': {
                        this.out.append('\\').append('n');
                        continue block9;
                    }
                    case '\r': {
                        this.out.append('\\').append('r');
                        continue block9;
                    }
                    case '\t': {
                        this.out.append('\\').append('t');
                        continue block9;
                    }
                    default: {
                        if (c > '\u001f' && c < '\u007f') {
                            this.out.append(c);
                            continue block9;
                        }
                        this.out.append('\\').append('u');
                        this.out.append(hex[c >> 12 & 0xF]);
                        this.out.append(hex[c >> 8 & 0xF]);
                        this.out.append(hex[c >> 4 & 0xF]);
                        this.out.append(hex[c & 0xF]);
                    }
                }
            }
            this.out.append('\"');
        }

        private void encodeDATA(byte[] value) {
            this.out.append('\"');
            this.out.append("0x");
            for (int pos = 0; pos < value.length; ++pos) {
                this.out.append(hex[value[pos] >> 4 & 0xF]);
                this.out.append(hex[value[pos] & 0xF]);
            }
            this.out.append('\"');
        }

        private void encodeARRAY(Inspector inspector) {
            this.openScope("[");
            StringEncoder at = this;
            inspector.traverse(at);
            this.closeScope("]");
        }

        private void encodeOBJECT(Inspector inspector) {
            this.openScope("{");
            StringEncoder ot = this;
            inspector.traverse(ot);
            this.closeScope("}");
        }

        private void openScope(String opener) {
            this.out.append(opener);
            ++this.level;
            this.head = true;
        }

        private void closeScope(String closer) {
            --this.level;
            this.separate(false);
            this.out.append(closer);
        }

        private void encodeValue(Inspector inspector) {
            switch (inspector.type()) {
                case EMPTY: {
                    this.encodeEMPTY();
                    return;
                }
                case BOOL: {
                    this.encodeBOOL(inspector.asBool());
                    return;
                }
                case LONG: {
                    this.encodeLONG(inspector.asLong());
                    return;
                }
                case DOUBLE: {
                    this.encodeDOUBLE(inspector.asDouble());
                    return;
                }
                case STRING: {
                    this.encodeSTRING(inspector.asString());
                    return;
                }
                case DATA: {
                    this.encodeDATA(inspector.asData());
                    return;
                }
                case ARRAY: {
                    this.encodeARRAY(inspector);
                    return;
                }
                case OBJECT: {
                    this.encodeOBJECT(inspector);
                    return;
                }
            }
            assert (false) : "Should not be reached";
        }

        private void separate(boolean useComma) {
            if (!this.head && useComma) {
                this.out.append(',');
            } else {
                this.head = false;
            }
            if (!this.compact) {
                this.out.append("\n");
                for (int lvl = 0; lvl < this.level; ++lvl) {
                    this.out.append(" ");
                }
            }
        }

        @Override
        public void entry(int idx, Inspector inspector) {
            this.separate(true);
            this.encodeValue(inspector);
        }

        @Override
        public void field(String name, Inspector inspector) {
            this.separate(true);
            this.encodeSTRING(name);
            this.out.append(':');
            if (!this.compact) {
                this.out.append(' ');
            }
            this.encodeValue(inspector);
        }
    }
}

