/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

public final class Hashlet<K, V> {
    private static final int[] emptyHash = new int[1];
    private int capacity = 0;
    private int used = 0;
    private Object[] store;
    private int[] hash = emptyHash;

    private int hashSize() {
        return this.capacity + this.capacity / 2 - 1;
    }

    public Hashlet() {
    }

    public Hashlet(Hashlet<K, V> hashlet) {
        if (hashlet.used > 0) {
            this.capacity = hashlet.capacity;
            this.used = hashlet.used;
            this.store = new Object[hashlet.store.length];
            this.hash = new int[hashlet.hash.length];
            System.arraycopy(hashlet.store, 0, this.store, 0, this.store.length);
            System.arraycopy(hashlet.hash, 0, this.hash, 0, this.hash.length);
        }
    }

    public void reserve(int n) {
        if (this.used + n > this.capacity) {
            int c = this.capacity;
            if (this.capacity == 0) {
                this.capacity = 16;
            }
            while (this.used + n > this.capacity) {
                this.capacity *= 2;
            }
            Object[] s = this.store;
            this.store = new Object[this.capacity * 2];
            this.hash = new int[this.hashSize() + this.capacity * 2];
            if (c > 0) {
                System.arraycopy(s, 0, this.store, 0, this.used);
                System.arraycopy(s, c, this.store, this.capacity, this.used);
                int i = 0;
                while (i < this.used) {
                    int insertIdx;
                    int prev = Math.abs(s[i].hashCode() % this.hashSize());
                    int entry = this.hash[prev];
                    while (entry != 0) {
                        prev = entry + 1;
                        entry = this.hash[prev];
                    }
                    this.hash[prev] = insertIdx = this.hashSize() + i * 2;
                    this.hash[insertIdx] = i++;
                }
            }
        }
    }

    public int size() {
        return this.used;
    }

    public K key(int i) {
        return (K)this.store[i];
    }

    public V value(int i) {
        return (V)this.store[this.capacity + i];
    }

    public V setValue(int i, V value) {
        V prev = this.value(i);
        this.store[this.capacity + i] = value;
        return prev;
    }

    public V put(K key, V value) {
        int insertIdx;
        this.reserve(1);
        int prev = Math.abs(key.hashCode() % this.hashSize());
        int entry = this.hash[prev];
        while (entry != 0) {
            int idx = this.hash[entry];
            if (this.store[idx].equals(key)) {
                Object ret = this.store[this.capacity + idx];
                this.store[this.capacity + idx] = value;
                return (V)ret;
            }
            prev = entry + 1;
            entry = this.hash[prev];
        }
        this.hash[prev] = insertIdx = this.hashSize() + this.used * 2;
        this.hash[insertIdx] = this.used;
        this.store[this.used] = key;
        this.store[this.capacity + this.used++] = value;
        return null;
    }

    public V get(Object key) {
        int index = this.getIndexOfKey(key);
        return index != -1 ? (V)this.value(index) : null;
    }

    public int getIndexOfKey(Object key) {
        int entry = this.hash[Math.abs(key.hashCode() % this.hashSize())];
        while (entry != 0) {
            int idx = this.hash[entry];
            if (this.store[idx].equals(key)) {
                return idx;
            }
            entry = this.hash[entry + 1];
        }
        return -1;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.used; ++i) {
            h += this.key(i).hashCode();
            V v = this.value(i);
            if (v == null) continue;
            h += v.hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Hashlet)) {
            return false;
        }
        Hashlet rhs = (Hashlet)o;
        if (this.used != rhs.used) {
            return false;
        }
        for (int i = 0; i < this.used; ++i) {
            boolean equal;
            int bi = rhs.getIndexOfKey(this.key(i));
            if (bi == -1) {
                return false;
            }
            V a = this.value(i);
            V b = rhs.value(bi);
            boolean bl = a == null ? b == null : (equal = a.equals(b));
            if (equal) continue;
            return false;
        }
        return true;
    }
}

