/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public final class Utf8 {
    private static final byte[] TRUE = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE = new byte[]{102, 97, 108, 115, 101};
    private static final byte[] LONG_MIN_VALUE_BYTES = String.valueOf(Long.MIN_VALUE).getBytes(StandardCharsets.UTF_8);

    public static Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    public static String toStringStd(byte[] data) {
        return new String(data, StandardCharsets.UTF_8);
    }

    public static String toString(byte[] data, int offset, int length) {
        String s = Utf8.toStringAscii(data, offset, length);
        return s != null ? s : Utf8.toString(ByteBuffer.wrap(data, offset, length));
    }

    public static String toString(ByteBuffer data) {
        CharBuffer c = StandardCharsets.UTF_8.decode(data);
        return c.toString();
    }

    public static byte[] toBytesStd(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] toAsciiBytes(long l) {
        long v;
        if (Long.MIN_VALUE == l) {
            return LONG_MIN_VALUE_BYTES;
        }
        int count = 1;
        long l2 = v = l < 0L ? -l : l;
        while (v >= 10L) {
            v /= 10L;
            ++count;
        }
        byte[] buf = new byte[count + (l < 0L ? 1 : 0)];
        int offset = 0;
        if (l < 0L) {
            buf[offset++] = 45;
            l = -l;
        }
        --count;
        while (count >= 0) {
            buf[count + offset] = (byte)(48L + l % 10L);
            l /= 10L;
            --count;
        }
        return buf;
    }

    public static byte[] toAsciiBytes(boolean v) {
        return v ? TRUE : FALSE;
    }

    public static byte[] toBytes(String str) {
        byte[] utf8 = Utf8.toBytesAscii(str);
        return utf8 != null ? utf8 : str.getBytes(StandardCharsets.UTF_8);
    }

    public static String toString(byte[] utf8) {
        String s = Utf8.toStringAscii(utf8, 0, utf8.length);
        return s != null ? s : new String(utf8, StandardCharsets.UTF_8);
    }

    private static byte[] toBytesAscii(CharSequence str) {
        byte[] utf8 = new byte[str.length()];
        for (int i = 0; i < utf8.length; ++i) {
            char c = str.charAt(i);
            if (c < '\u0000' || c >= '\u0080') {
                return null;
            }
            utf8[i] = (byte)c;
        }
        return utf8;
    }

    private static String toStringAscii(byte[] b, int offset, int length) {
        if (length > 0) {
            char[] s = new char[length];
            for (int i = 0; i < length; ++i) {
                if (b[offset + i] < 0) {
                    return null;
                }
                s[i] = (char)b[offset + i];
            }
            return new String(s);
        }
        return "";
    }

    public static byte[] toBytes(String str, int offset, int length) {
        CharBuffer c = CharBuffer.wrap(str, offset, offset + length);
        ByteBuffer b = StandardCharsets.UTF_8.encode(c);
        byte[] result = new byte[b.remaining()];
        b.get(result);
        return result;
    }

    public static int toBytes(String str, int srcOffset, int srcLen, byte[] dst, int dstOffset) {
        CharBuffer c = CharBuffer.wrap(str, srcOffset, srcOffset + srcLen);
        ByteBuffer b = StandardCharsets.UTF_8.encode(c);
        int encoded = b.remaining();
        b.get(dst, dstOffset, encoded);
        return encoded;
    }

    public static void toBytes(String src, int srcOffset, int srcLen, ByteBuffer dst, CharsetEncoder encoder) {
        CharBuffer c = CharBuffer.wrap(src, srcOffset, srcOffset + srcLen);
        encoder.encode(c, dst, true);
    }

    public static CharsetEncoder getNewEncoder() {
        return StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public static int byteCount(CharSequence str) {
        return Utf8.byteCount(str, 0, str.length());
    }

    public static int byteCount(CharSequence str, int offset, int length) {
        int count = 0;
        int barrier = offset + length;
        int i = offset;
        while (i < barrier) {
            char codePoint = str.charAt(i);
            if (codePoint < '\u0800') {
                count = codePoint < '\u0080' ? ++count : (count += 2);
                ++i;
                continue;
            }
            if ((codePoint & 0xF800) == 55296) {
                count += 4;
                i += 2;
                continue;
            }
            count += 3;
            ++i;
        }
        return count;
    }

    public static int unitCount(byte[] utf8) {
        return Utf8.unitCount(utf8, 0, utf8.length);
    }

    public static int unitCount(byte[] utf8, int offset, int length) {
        int units = 0;
        int barrier = offset + length;
        int i = offset;
        while (i < barrier) {
            byte firstByte = utf8[i];
            if (firstByte >= -16) {
                if (firstByte >= 0) {
                    ++units;
                    ++i;
                    continue;
                }
                units += 2;
                i += 4;
                continue;
            }
            if (firstByte >= -32) {
                ++units;
                i += 3;
                continue;
            }
            ++units;
            i += 2;
        }
        return units;
    }

    public static int unitCount(byte firstByte) {
        int units = 0;
        units = firstByte >= -16 ? (firstByte >= 0 ? 1 : 2) : 1;
        return units;
    }

    public static int totalBytes(byte firstByte) {
        if (firstByte >= -16) {
            if (firstByte >= 0) {
                return 1;
            }
            return 4;
        }
        if (firstByte >= -32) {
            return 3;
        }
        return 2;
    }

    public static int[] calculateBytePositions(CharSequence value) {
        int[] positions = new int[value.length() + 1];
        int bytePos = 0;
        int barrier = value.length();
        int i = 0;
        int codepointNo = 0;
        positions[codepointNo++] = bytePos;
        while (i < barrier) {
            char codePoint = value.charAt(i);
            if (codePoint < '\u0800') {
                if (codePoint >= '\u0080') {
                    bytePos += 2;
                }
                ++i;
            } else if ((codePoint & 0xF800) == 55296) {
                positions[codepointNo++] = bytePos;
                bytePos += 4;
                i += 2;
            } else {
                bytePos += 3;
                ++i;
            }
            positions[codepointNo++] = ++bytePos;
        }
        return positions;
    }

    public static int[] calculateStringPositions(byte[] utf8) {
        if (utf8.length == 0) {
            return new int[]{0};
        }
        int[] positions = new int[utf8.length + 1];
        int utf8BytePos = 0;
        int charPos = 0;
        int lastUtf8SequencePos = 0;
        int utf8SequenceLen = 0;
        while (utf8BytePos < utf8.length) {
            utf8SequenceLen = Utf8.totalBytes(utf8[utf8BytePos]);
            lastUtf8SequencePos = utf8BytePos;
            for (int utf8SequenceCnt = 0; utf8SequenceCnt < utf8SequenceLen; ++utf8SequenceCnt) {
                positions[utf8BytePos + utf8SequenceCnt] = charPos;
            }
            utf8BytePos += utf8SequenceLen;
            ++charPos;
        }
        int lastCharLen = Utf8.unitCount(utf8, lastUtf8SequencePos, utf8SequenceLen);
        positions[utf8.length] = charPos + lastCharLen - 1;
        return positions;
    }

    public static byte[] encode(int codepoint) {
        byte[] destination = new byte[Utf8.codePointAsUtf8Length(codepoint)];
        Utf8.encode(codepoint, destination, 0);
        return destination;
    }

    public static int encode(int codepoint, byte[] destination, int offset) {
        int writeOffset = offset;
        byte firstByte = Utf8.firstByte(codepoint);
        int leftToWrite = Utf8.codePointAsUtf8Length(codepoint) - 1;
        destination[writeOffset++] = firstByte;
        while (leftToWrite-- > 0) {
            destination[writeOffset++] = Utf8.trailingOctet(codepoint, leftToWrite);
        }
        return writeOffset;
    }

    public static void encode(int codepoint, ByteBuffer destination) {
        byte firstByte = Utf8.firstByte(codepoint);
        int leftToWrite = Utf8.codePointAsUtf8Length(codepoint) - 1;
        destination.put(firstByte);
        while (leftToWrite-- > 0) {
            destination.put(Utf8.trailingOctet(codepoint, leftToWrite));
        }
    }

    public static int encode(int codepoint, OutputStream destination) throws IOException {
        byte firstByte = Utf8.firstByte(codepoint);
        int toWrite = Utf8.codePointAsUtf8Length(codepoint);
        int leftToWrite = toWrite - 1;
        destination.write(firstByte);
        while (leftToWrite-- > 0) {
            destination.write(Utf8.trailingOctet(codepoint, leftToWrite));
        }
        return toWrite;
    }

    private static byte trailingOctet(int codepoint, int leftToWrite) {
        return (byte)(0x80 | codepoint >> 6 * leftToWrite & 0x3F);
    }

    private static byte firstByte(int codepoint) {
        if (codepoint < 2048) {
            if (codepoint < 128) {
                return (byte)codepoint;
            }
            return (byte)(0xC0 | codepoint >> 6);
        }
        if (codepoint < 65536) {
            return (byte)(0xE0 | codepoint >> 12);
        }
        return (byte)(0xF0 | codepoint >> 18);
    }

    public static int codePointAsUtf8Length(int codepoint) {
        if (codepoint < 2048) {
            if (codepoint < 128) {
                return 1;
            }
            return 2;
        }
        if (codepoint < 65536) {
            return 3;
        }
        return 4;
    }
}

