/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.EvaluationContext;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.List;

public class ConstantTensor
extends PrimitiveTensorFunction {
    private final Tensor constant;

    public ConstantTensor(String tensorString) {
        this.constant = Tensor.from(tensorString);
    }

    public ConstantTensor(Tensor tensor) {
        this.constant = tensor;
    }

    @Override
    public List<TensorFunction> arguments() {
        return Collections.emptyList();
    }

    @Override
    public TensorFunction withArguments(List<TensorFunction> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("ConstantTensor must have 0 arguments, got " + arguments.size());
        }
        return this;
    }

    @Override
    public PrimitiveTensorFunction toPrimitive() {
        return this;
    }

    @Override
    public <NAMETYPE extends TypeContext.Name> TensorType type(TypeContext<NAMETYPE> context) {
        return this.constant.type();
    }

    @Override
    public <NAMETYPE extends TypeContext.Name> Tensor evaluate(EvaluationContext<NAMETYPE> context) {
        return this.constant;
    }

    @Override
    public String toString(ToStringContext context) {
        return this.constant.toString();
    }
}

