/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.TensorType;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;

public abstract class TensorAddress
implements Comparable<TensorAddress> {
    public static TensorAddress of(String[] labels) {
        return new StringTensorAddress(labels);
    }

    public static TensorAddress of(long ... labels) {
        return new NumericTensorAddress(labels);
    }

    public abstract int size();

    public abstract String label(int var1);

    public abstract long numericLabel(int var1);

    public abstract TensorAddress withLabel(int var1, long var2);

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int compareTo(TensorAddress other) {
        for (int i = 0; i < this.size(); ++i) {
            int elementComparison = this.label(i).compareTo(other.label(i));
            if (elementComparison == 0) continue;
            return elementComparison;
        }
        return 0;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            result = 31 * result + this.label(i).hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TensorAddress)) {
            return false;
        }
        TensorAddress other = (TensorAddress)o;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.label(i).equals(other.label(i))) continue;
            return false;
        }
        return true;
    }

    public final String toString(TensorType type) {
        StringBuilder b = new StringBuilder("{");
        for (int i = 0; i < this.size(); ++i) {
            b.append(type.dimensions().get(i).name()).append(":").append(this.label(i));
            b.append(",");
        }
        if (b.length() > 1) {
            b.setLength(b.length() - 1);
        }
        b.append("}");
        return b.toString();
    }

    public static class Builder {
        private Pattern identifierPattern = Pattern.compile("[A-Za-z0-9_]+");
        private final TensorType type;
        private final String[] labels;

        public Builder(TensorType type) {
            this(type, new String[type.dimensions().size()]);
        }

        private Builder(TensorType type, String[] labels) {
            this.type = type;
            this.labels = labels;
        }

        public Builder add(String dimension, String label) {
            this.requireIdentifier(dimension, "dimension");
            this.requireIdentifier(label, "label");
            Optional<Integer> labelIndex = this.type.indexOfDimension(dimension);
            if (!labelIndex.isPresent()) {
                throw new IllegalArgumentException(this.type + " does not contain dimension '" + dimension + "'");
            }
            this.labels[labelIndex.get().intValue()] = label;
            return this;
        }

        public Builder copy() {
            return new Builder(this.type, Arrays.copyOf(this.labels, this.labels.length));
        }

        public TensorAddress build() {
            for (int i = 0; i < this.labels.length; ++i) {
                if (this.labels[i] != null) continue;
                throw new IllegalArgumentException("Missing a value for dimension " + this.type.dimensions().get(i).name() + " for " + this.type);
            }
            return TensorAddress.of(this.labels);
        }

        private void requireIdentifier(String s, String parameterName) {
            if (s == null) {
                throw new IllegalArgumentException(parameterName + " can not be null");
            }
            if (!this.identifierPattern.matcher(s).matches()) {
                throw new IllegalArgumentException(parameterName + " must be an identifier or integer, not '" + s + "'");
            }
        }
    }

    private static final class NumericTensorAddress
    extends TensorAddress {
        private final long[] labels;

        private NumericTensorAddress(long[] labels) {
            this.labels = Arrays.copyOf(labels, labels.length);
        }

        @Override
        public int size() {
            return this.labels.length;
        }

        @Override
        public String label(int i) {
            return String.valueOf(this.labels[i]);
        }

        @Override
        public long numericLabel(int i) {
            return this.labels[i];
        }

        @Override
        public TensorAddress withLabel(int index, long label) {
            long[] labels = Arrays.copyOf(this.labels, this.labels.length);
            labels[index] = label;
            return new NumericTensorAddress(labels);
        }

        public String toString() {
            return Arrays.toString(this.labels);
        }
    }

    private static final class StringTensorAddress
    extends TensorAddress {
        private final String[] labels;

        private StringTensorAddress(String ... labels) {
            this.labels = Arrays.copyOf(labels, labels.length);
        }

        @Override
        public int size() {
            return this.labels.length;
        }

        @Override
        public String label(int i) {
            return this.labels[i];
        }

        @Override
        public long numericLabel(int i) {
            try {
                return Long.parseLong(this.labels[i]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expected a long label in " + this + " at position " + i);
            }
        }

        @Override
        public TensorAddress withLabel(int index, long label) {
            String[] labels = Arrays.copyOf(this.labels, this.labels.length);
            labels[index] = String.valueOf(label);
            return new StringTensorAddress(labels);
        }

        public String toString() {
            return Arrays.toString(this.labels);
        }
    }
}

