/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.time;

import com.google.common.annotations.Beta;

@Beta
public class WallClockSource {
    private volatile long offset;
    private static WallClockSource autoAdjustingInstance = new WallClockSource();
    private Thread adjuster;

    public final long currentTimeNanos() {
        return System.nanoTime() + this.offset;
    }

    WallClockSource() {
        long actual = System.currentTimeMillis();
        this.offset = (actual *= 1000000L) - System.nanoTime();
        this.initialAdjust();
    }

    boolean adjust() {
        long nanosB = System.nanoTime();
        long actual = System.currentTimeMillis();
        long nanosA = System.nanoTime();
        if (nanosA - nanosB > 100000L) {
            return true;
        }
        return this.adjustOffset(nanosB, actual, nanosA);
    }

    private boolean adjustOffset(long before, long actual, long after) {
        if ((actual *= 1000000L) > after + this.offset) {
            this.offset = actual - after;
            return true;
        }
        if (actual + 999999L < before + this.offset) {
            this.offset = actual + 999999L - before;
            return true;
        }
        return false;
    }

    private void initialAdjust() {
        for (int i = 0; i < 100; ++i) {
            long nanosB = System.nanoTime();
            long actual = System.currentTimeMillis();
            long nanosA = System.nanoTime();
            this.adjustOffset(nanosB, actual, nanosA);
        }
    }

    public static WallClockSource get() {
        autoAdjustingInstance.startAdjuster();
        return autoAdjustingInstance;
    }

    private synchronized void startAdjuster() {
        if (this.adjuster == null) {
            this.adjuster = new AdjustThread();
            this.adjuster.setDaemon(true);
            this.adjuster.start();
        }
    }

    private class AdjustThread
    extends Thread {
        private AdjustThread() {
        }

        @Override
        public void run() {
            int millis = 0;
            int nanos = 313373;
            while (true) {
                try {
                    AdjustThread.sleep(millis, nanos);
                    if (++millis > 4321) {
                        millis = 1000;
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                if (!WallClockSource.this.adjust()) continue;
                millis = 0;
            }
        }
    }
}

