/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

public final class DoubleParser {
    private static double[] tens = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64, 1.0E65, 1.0E66, 1.0E67, 1.0E68, 1.0E69, 1.0E70, 1.0E71, 1.0E72, 1.0E73, 1.0E74, 1.0E75, 1.0E76, 1.0E77, 1.0E78, 1.0E79, 1.0E80, 1.0E81, 1.0E82, 1.0E83, 1.0E84, 1.0E85, 1.0E86, 1.0E87, 1.0E88, 1.0E89, 1.0E90, 1.0E91, 1.0E92, 1.0E93, 1.0E94, 1.0E95, 1.0E96, 1.0E97, 1.0E98, 1.0E99};
    private static double[] tenths = new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10, 1.0E-11, 1.0E-12, 1.0E-13, 1.0E-14, 1.0E-15, 1.0E-16, 1.0E-17, 1.0E-18, 1.0E-19, 1.0E-20, 1.0E-21, 1.0E-22, 1.0E-23, 1.0E-24, 1.0E-25, 1.0E-26, 1.0E-27, 1.0E-28, 1.0E-29, 1.0E-30, 1.0E-31, 1.0E-32, 1.0E-33, 1.0E-34, 1.0E-35, 1.0E-36, 1.0E-37, 1.0E-38, 1.0E-39, 1.0E-40, 1.0E-41, 1.0E-42, 1.0E-43, 1.0E-44, 1.0E-45, 1.0E-46, 1.0E-47, 1.0E-48, 1.0E-49, 1.0E-50, 1.0E-51, 1.0E-52, 1.0E-53, 1.0E-54, 1.0E-55, 1.0E-56, 1.0E-57, 1.0E-58, 1.0E-59, 1.0E-60, 1.0E-61, 1.0E-62, 1.0E-63, 1.0E-64, 1.0E-65, 1.0E-66, 1.0E-67, 1.0E-68, 1.0E-69, 1.0E-70, 1.0E-71, 1.0E-72, 1.0E-73, 1.0E-74, 1.0E-75, 1.0E-76, 1.0E-77, 1.0E-78, 1.0E-79, 1.0E-80, 1.0E-81, 1.0E-82, 1.0E-83, 1.0E-84, 1.0E-85, 1.0E-86, 1.0E-87, 1.0E-88, 1.0E-89, 1.0E-90, 1.0E-91, 1.0E-92, 1.0E-93, 1.0E-94, 1.0E-95, 1.0E-96, 1.0E-97, 1.0E-98, 1.0E-99};

    public static double parse(String data) {
        int i;
        int len = data.length();
        double result = 0.0;
        boolean negative = false;
        int beforePoint = 0;
        int exponent = 0;
        byte[] digits = new byte[25];
        int numDigits = 0;
        for (i = 0; i < len && Character.isWhitespace(data.charAt(i)); ++i) {
        }
        if (data.charAt(i) == '+') {
            ++i;
        } else if (data.charAt(i) == '-') {
            negative = true;
            ++i;
        }
        if (i + 3 <= len && data.substring(i, i + 3).equals("NaN")) {
            i += 3;
            result = Double.NaN;
        } else if (i + 8 <= len && data.substring(i, i + 8).equals("Infinity")) {
            i += 8;
            result = negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        } else {
            int dval;
            while (i < len && Character.isDigit(data.charAt(i))) {
                dval = Character.digit(data.charAt(i), 10);
                assert (dval >= 0);
                assert (dval < 10);
                if (numDigits < 25) {
                    digits[numDigits++] = (byte)dval;
                }
                ++beforePoint;
                ++i;
            }
            if (i < len && data.charAt(i) == '.') {
                ++i;
                while (i < len && Character.isDigit(data.charAt(i))) {
                    dval = Character.digit(data.charAt(i), 10);
                    assert (dval >= 0);
                    assert (dval < 10);
                    if (numDigits < 25) {
                        digits[numDigits++] = (byte)dval;
                    }
                    ++i;
                }
            }
            if (numDigits == 0) {
                throw new NumberFormatException("No digits in number: '" + data + "'");
            }
            if (i < len && (data.charAt(i) == 'e' || data.charAt(i) == 'E')) {
                boolean expNeg = false;
                int expDigits = 0;
                if (data.charAt(++i) == '+') {
                    ++i;
                } else if (data.charAt(i) == '-') {
                    expNeg = true;
                    ++i;
                }
                while (i < len && Character.isDigit(data.charAt(i))) {
                    int dval2 = Character.digit(data.charAt(i), 10);
                    assert (dval2 >= 0);
                    assert (dval2 < 10);
                    exponent *= 10;
                    exponent += dval2;
                    ++expDigits;
                    ++i;
                }
                if (expDigits == 0) {
                    throw new NumberFormatException("Missing digits in exponent part: " + data);
                }
                if (expNeg) {
                    exponent = -exponent;
                }
            }
            exponent += beforePoint;
            exponent -= numDigits;
            for (int d = numDigits; d > 0; --d) {
                double dv = digits[d - 1];
                result += (dv *= DoubleParser.powTen(numDigits - d));
            }
            while (exponent < -99) {
                result *= DoubleParser.powTen(-99);
                exponent += 99;
            }
            while (exponent > 99) {
                result *= DoubleParser.powTen(99);
                exponent -= 99;
            }
            result *= DoubleParser.powTen(exponent);
            if (negative) {
                result = -result;
            }
        }
        while (i < len && Character.isWhitespace(data.charAt(i))) {
            ++i;
        }
        if (i < len) {
            throw new NumberFormatException("Extra characters after number: " + data.substring(i));
        }
        return result;
    }

    private static double powTen(int exponent) {
        if (exponent > 0) {
            assert (exponent < 100);
            return tens[exponent];
        }
        if (exponent < 0) {
            exponent = -exponent;
            assert (exponent < 100);
            return tenths[exponent];
        }
        return 1.0;
    }
}

