/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.serialization;

import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.MixedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.serialization.DenseBinaryFormat;
import com.yahoo.tensor.serialization.MixedBinaryFormat;
import com.yahoo.tensor.serialization.SparseBinaryFormat;
import java.util.Optional;

public class TypedBinaryFormat {
    private static final int SPARSE_BINARY_FORMAT_TYPE = 1;
    private static final int DENSE_BINARY_FORMAT_TYPE = 2;
    private static final int MIXED_BINARY_FORMAT_TYPE = 3;

    public static byte[] encode(Tensor tensor) {
        GrowableByteBuffer buffer = new GrowableByteBuffer();
        if (tensor instanceof MixedTensor) {
            buffer.putInt1_4Bytes(3);
            new MixedBinaryFormat().encode(buffer, tensor);
        } else if (tensor instanceof IndexedTensor) {
            buffer.putInt1_4Bytes(2);
            new DenseBinaryFormat().encode(buffer, tensor);
        } else {
            buffer.putInt1_4Bytes(1);
            new SparseBinaryFormat().encode(buffer, tensor);
        }
        buffer.flip();
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    public static Tensor decode(Optional<TensorType> type, GrowableByteBuffer buffer) {
        int formatType = buffer.getInt1_4Bytes();
        switch (formatType) {
            case 3: {
                return new MixedBinaryFormat().decode(type, buffer);
            }
            case 1: {
                return new SparseBinaryFormat().decode(type, buffer);
            }
            case 2: {
                return new DenseBinaryFormat().decode(type, buffer);
            }
        }
        throw new IllegalArgumentException("Binary format type " + formatType + " is unknown");
    }
}

