/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.google.common.collect.ImmutableList;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.EvaluationContext;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Reduce
extends PrimitiveTensorFunction {
    private final TensorFunction argument;
    private final List<String> dimensions;
    private final Aggregator aggregator;

    public Reduce(TensorFunction argument, Aggregator aggregator) {
        this(argument, aggregator, Collections.emptyList());
    }

    public Reduce(TensorFunction argument, Aggregator aggregator, String dimension) {
        this(argument, aggregator, Collections.singletonList(dimension));
    }

    public Reduce(TensorFunction argument, Aggregator aggregator, List<String> dimensions) {
        Objects.requireNonNull(argument, "The argument tensor cannot be null");
        Objects.requireNonNull(aggregator, "The aggregator cannot be null");
        Objects.requireNonNull(dimensions, "The dimensions cannot be null");
        this.argument = argument;
        this.aggregator = aggregator;
        this.dimensions = ImmutableList.copyOf(dimensions);
    }

    public static TensorType outputType(TensorType inputType, List<String> reduceDimensions) {
        TensorType.Builder b = new TensorType.Builder();
        for (TensorType.Dimension dimension : inputType.dimensions()) {
            if (reduceDimensions.contains(dimension.name())) continue;
            b.dimension(dimension);
        }
        return b.build();
    }

    public TensorFunction argument() {
        return this.argument;
    }

    @Override
    public List<TensorFunction> arguments() {
        return Collections.singletonList(this.argument);
    }

    @Override
    public TensorFunction withArguments(List<TensorFunction> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Reduce must have 1 argument, got " + arguments.size());
        }
        return new Reduce(arguments.get(0), this.aggregator, this.dimensions);
    }

    @Override
    public PrimitiveTensorFunction toPrimitive() {
        return new Reduce((TensorFunction)this.argument.toPrimitive(), this.aggregator, this.dimensions);
    }

    @Override
    public String toString(ToStringContext context) {
        return "reduce(" + this.argument.toString(context) + ", " + (Object)((Object)this.aggregator) + this.commaSeparated(this.dimensions) + ")";
    }

    private String commaSeparated(List<String> list) {
        StringBuilder b = new StringBuilder();
        for (String element : list) {
            b.append(", ").append(element);
        }
        return b.toString();
    }

    @Override
    public <NAMETYPE extends TypeContext.Name> TensorType type(TypeContext<NAMETYPE> context) {
        return this.type(this.argument.type(context));
    }

    private TensorType type(TensorType argumentType) {
        if (this.dimensions.isEmpty()) {
            return TensorType.empty;
        }
        TensorType.Builder builder = new TensorType.Builder();
        for (TensorType.Dimension dimension : argumentType.dimensions()) {
            if (this.dimensions.contains(dimension.name())) continue;
            builder.dimension(dimension);
        }
        return builder.build();
    }

    @Override
    public <NAMETYPE extends TypeContext.Name> Tensor evaluate(EvaluationContext<NAMETYPE> context) {
        Tensor argument = this.argument.evaluate(context);
        if (!this.dimensions.isEmpty() && !argument.type().dimensionNames().containsAll(this.dimensions)) {
            throw new IllegalArgumentException("Cannot reduce " + argument + " over dimensions " + this.dimensions + ": Not all those dimensions are present in this tensor");
        }
        if (this.dimensions.isEmpty() || this.dimensions.size() == argument.type().dimensions().size()) {
            if (argument.type().dimensions().size() == 1 && argument instanceof IndexedTensor) {
                return this.reduceIndexedVector((IndexedTensor)argument);
            }
            return this.reduceAllGeneral(argument);
        }
        TensorType reducedType = this.type(argument.type());
        HashMap<TensorAddress, ValueAggregator> aggregatingCells = new HashMap<TensorAddress, ValueAggregator>();
        Iterator<Tensor.Cell> i = argument.cellIterator();
        while (i.hasNext()) {
            Map.Entry cell = i.next();
            TensorAddress reducedAddress = this.reduceDimensions((TensorAddress)cell.getKey(), argument.type(), reducedType);
            aggregatingCells.putIfAbsent(reducedAddress, ValueAggregator.ofType(this.aggregator));
            ((ValueAggregator)aggregatingCells.get(reducedAddress)).aggregate((Double)cell.getValue());
        }
        Tensor.Builder reducedBuilder = Tensor.Builder.of(reducedType);
        for (Map.Entry aggregatingCell : aggregatingCells.entrySet()) {
            reducedBuilder.cell((TensorAddress)aggregatingCell.getKey(), ((ValueAggregator)aggregatingCell.getValue()).aggregatedValue());
        }
        return reducedBuilder.build();
    }

    private TensorAddress reduceDimensions(TensorAddress address, TensorType argumentType, TensorType reducedType) {
        HashSet<Integer> indexesToRemove = new HashSet<Integer>();
        for (String dimensionToRemove : this.dimensions) {
            indexesToRemove.add(argumentType.indexOfDimension(dimensionToRemove).get());
        }
        String[] reducedLabels = new String[reducedType.dimensions().size()];
        int reducedLabelIndex = 0;
        for (int i = 0; i < address.size(); ++i) {
            if (indexesToRemove.contains(i)) continue;
            reducedLabels[reducedLabelIndex++] = address.label(i);
        }
        return TensorAddress.of(reducedLabels);
    }

    private Tensor reduceAllGeneral(Tensor argument) {
        ValueAggregator valueAggregator = ValueAggregator.ofType(this.aggregator);
        Iterator<Double> i = argument.valueIterator();
        while (i.hasNext()) {
            valueAggregator.aggregate(i.next());
        }
        return Tensor.Builder.of(TensorType.empty).cell(valueAggregator.aggregatedValue(), new long[0]).build();
    }

    private Tensor reduceIndexedVector(IndexedTensor argument) {
        ValueAggregator valueAggregator = ValueAggregator.ofType(this.aggregator);
        int i = 0;
        while ((long)i < argument.dimensionSizes().size(0)) {
            valueAggregator.aggregate(argument.get(new long[]{i}));
            ++i;
        }
        return Tensor.Builder.of(TensorType.empty).cell(valueAggregator.aggregatedValue(), new long[0]).build();
    }

    private static class MinAggregator
    extends ValueAggregator {
        private double minValue = Double.MAX_VALUE;

        private MinAggregator() {
        }

        @Override
        public void aggregate(double value) {
            if (value < this.minValue) {
                this.minValue = value;
            }
        }

        @Override
        public double aggregatedValue() {
            return this.minValue;
        }
    }

    private static class MaxAggregator
    extends ValueAggregator {
        private double maxValue = Double.MIN_VALUE;

        private MaxAggregator() {
        }

        @Override
        public void aggregate(double value) {
            if (value > this.maxValue) {
                this.maxValue = value;
            }
        }

        @Override
        public double aggregatedValue() {
            return this.maxValue;
        }
    }

    private static class SumAggregator
    extends ValueAggregator {
        private double valueSum = 0.0;

        private SumAggregator() {
        }

        @Override
        public void aggregate(double value) {
            this.valueSum += value;
        }

        @Override
        public double aggregatedValue() {
            return this.valueSum;
        }
    }

    private static class ProdAggregator
    extends ValueAggregator {
        private double valueProd = 1.0;

        private ProdAggregator() {
        }

        @Override
        public void aggregate(double value) {
            this.valueProd *= value;
        }

        @Override
        public double aggregatedValue() {
            return this.valueProd;
        }
    }

    private static class CountAggregator
    extends ValueAggregator {
        private int valueCount = 0;

        private CountAggregator() {
        }

        @Override
        public void aggregate(double value) {
            ++this.valueCount;
        }

        @Override
        public double aggregatedValue() {
            return this.valueCount;
        }
    }

    private static class AvgAggregator
    extends ValueAggregator {
        private int valueCount = 0;
        private double valueSum = 0.0;

        private AvgAggregator() {
        }

        @Override
        public void aggregate(double value) {
            ++this.valueCount;
            this.valueSum += value;
        }

        @Override
        public double aggregatedValue() {
            return this.valueSum / (double)this.valueCount;
        }
    }

    private static abstract class ValueAggregator {
        private ValueAggregator() {
        }

        private static ValueAggregator ofType(Aggregator aggregator) {
            switch (aggregator) {
                case avg: {
                    return new AvgAggregator();
                }
                case count: {
                    return new CountAggregator();
                }
                case prod: {
                    return new ProdAggregator();
                }
                case sum: {
                    return new SumAggregator();
                }
                case max: {
                    return new MaxAggregator();
                }
                case min: {
                    return new MinAggregator();
                }
            }
            throw new UnsupportedOperationException("Aggregator " + (Object)((Object)aggregator) + " is not implemented");
        }

        public abstract void aggregate(double var1);

        public abstract double aggregatedValue();
    }

    public static enum Aggregator {
        avg,
        count,
        prod,
        sum,
        max,
        min;

    }
}

