/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.yahoo.tensor.functions.CompositeTensorFunction;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.List;

@Beta
public class XwPlusB
extends CompositeTensorFunction {
    private final TensorFunction x;
    private final TensorFunction w;
    private final TensorFunction b;
    private final String dimension;

    public XwPlusB(TensorFunction x, TensorFunction w, TensorFunction b, String dimension) {
        this.x = x;
        this.w = w;
        this.b = b;
        this.dimension = dimension;
    }

    @Override
    public List<TensorFunction> functionArguments() {
        return ImmutableList.of((Object)this.x, (Object)this.w, (Object)this.b);
    }

    @Override
    public TensorFunction replaceArguments(List<TensorFunction> arguments) {
        if (arguments.size() != 3) {
            throw new IllegalArgumentException("XwPlusB must have 3 arguments, got " + arguments.size());
        }
        return new XwPlusB(arguments.get(0), arguments.get(1), arguments.get(2), this.dimension);
    }

    @Override
    public PrimitiveTensorFunction toPrimitive() {
        PrimitiveTensorFunction primitiveX = this.x.toPrimitive();
        PrimitiveTensorFunction primitiveW = this.w.toPrimitive();
        PrimitiveTensorFunction primitiveB = this.b.toPrimitive();
        return new Join(new Reduce((TensorFunction)new Join(primitiveX, primitiveW, ScalarFunctions.multiply()), Reduce.Aggregator.sum, this.dimension), primitiveB, ScalarFunctions.add());
    }

    @Override
    public String toString(ToStringContext context) {
        return "xw_plus_b(" + this.x.toString(context) + ", " + this.w.toString(context) + ", " + this.b.toString(context) + ", " + this.dimension + ")";
    }
}

