/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

@Beta
public class ScalarFunctions {
    public static DoubleBinaryOperator add() {
        return new Addition();
    }

    public static DoubleBinaryOperator multiply() {
        return new Multiplication();
    }

    public static DoubleBinaryOperator divide() {
        return new Division();
    }

    public static DoubleBinaryOperator equal() {
        return new Equal();
    }

    public static DoubleUnaryOperator square() {
        return new Square();
    }

    public static DoubleUnaryOperator sqrt() {
        return new Sqrt();
    }

    public static DoubleUnaryOperator exp() {
        return new Exponent();
    }

    public static Function<List<Integer>, Double> random() {
        return new Random();
    }

    public static Function<List<Integer>, Double> equal(List<String> argumentNames) {
        return new EqualElements(argumentNames);
    }

    public static Function<List<Integer>, Double> sum(List<String> argumentNames) {
        return new SumElements(argumentNames);
    }

    public static class SumElements
    implements Function<List<Integer>, Double> {
        private final ImmutableList<String> argumentNames;

        private SumElements(List<String> argumentNames) {
            this.argumentNames = ImmutableList.copyOf(argumentNames);
        }

        @Override
        public Double apply(List<Integer> values) {
            int sum = 0;
            for (Integer value : values) {
                sum += value.intValue();
            }
            return sum;
        }

        public String toString() {
            return this.argumentNames.stream().collect(Collectors.joining("+"));
        }
    }

    public static class EqualElements
    implements Function<List<Integer>, Double> {
        private final ImmutableList<String> argumentNames;

        private EqualElements(List<String> argumentNames) {
            this.argumentNames = ImmutableList.copyOf(argumentNames);
        }

        @Override
        public Double apply(List<Integer> values) {
            if (values.isEmpty()) {
                return 1.0;
            }
            for (Integer value : values) {
                if (value.equals(values.get(0))) continue;
                return 0.0;
            }
            return 1.0;
        }

        public String toString() {
            if (this.argumentNames.size() == 0) {
                return "1";
            }
            if (this.argumentNames.size() == 1) {
                return "1";
            }
            if (this.argumentNames.size() == 2) {
                return (String)this.argumentNames.get(0) + "==" + (String)this.argumentNames.get(1);
            }
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.argumentNames.size() - 1; ++i) {
                b.append("(").append((String)this.argumentNames.get(i)).append("==").append((String)this.argumentNames.get(i + 1)).append(")");
                if (i >= this.argumentNames.size() - 2) continue;
                b.append("*");
            }
            return b.toString();
        }
    }

    public static class Random
    implements Function<List<Integer>, Double> {
        @Override
        public Double apply(List<Integer> values) {
            return ThreadLocalRandom.current().nextDouble();
        }

        public String toString() {
            return "random";
        }
    }

    public static class Exponent
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.exp(operand);
        }

        public String toString() {
            return "f(a)(exp(a))";
        }
    }

    public static class Sqrt
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.sqrt(operand);
        }

        public String toString() {
            return "f(a)(sqrt(a))";
        }
    }

    public static class Square
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return operand * operand;
        }

        public String toString() {
            return "f(a)(a * a)";
        }
    }

    public static class Equal
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return left == right ? 1.0 : 0.0;
        }

        public String toString() {
            return "f(a,b)(a==b)";
        }
    }

    public static class Division
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return left / right;
        }

        public String toString() {
            return "f(a,b)(a / b)";
        }
    }

    public static class Multiplication
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return left * right;
        }

        public String toString() {
            return "f(a,b)(a * b)";
        }
    }

    public static class Addition
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return left + right;
        }

        public String toString() {
            return "f(a,b)(a + b)";
        }
    }
}

