/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.yahoo.tensor.functions.CompositeTensorFunction;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.List;

@Beta
public class Matmul
extends CompositeTensorFunction {
    private final TensorFunction argument1;
    private final TensorFunction argument2;
    private final String dimension;

    public Matmul(TensorFunction argument1, TensorFunction argument2, String dimension) {
        this.argument1 = argument1;
        this.argument2 = argument2;
        this.dimension = dimension;
    }

    @Override
    public List<TensorFunction> functionArguments() {
        return ImmutableList.of((Object)this.argument1, (Object)this.argument2);
    }

    @Override
    public TensorFunction replaceArguments(List<TensorFunction> arguments) {
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Matmul must have 2 arguments, got " + arguments.size());
        }
        return new Matmul(arguments.get(0), arguments.get(1), this.dimension);
    }

    @Override
    public PrimitiveTensorFunction toPrimitive() {
        PrimitiveTensorFunction primitiveArgument1 = this.argument1.toPrimitive();
        PrimitiveTensorFunction primitiveArgument2 = this.argument2.toPrimitive();
        return new Reduce((TensorFunction)new Join(primitiveArgument1, primitiveArgument2, ScalarFunctions.multiply()), Reduce.Aggregator.sum, this.dimension);
    }

    @Override
    public String toString(ToStringContext context) {
        return "matmul(" + this.argument1.toString(context) + ", " + this.argument2.toString(context) + ", " + this.dimension + ")";
    }
}

