/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.ArrayInserter;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.BufferedInput;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inserter;
import com.yahoo.slime.ObjectInserter;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeInserter;
import com.yahoo.slime.Type;
import com.yahoo.slime.Utf8Codec;

final class BinaryDecoder {
    BufferedInput in;
    private final SlimeInserter slimeInserter = new SlimeInserter();
    private final ArrayInserter arrayInserter = new ArrayInserter();
    private final ObjectInserter objectInserter = new ObjectInserter();

    public Slime decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public Slime decode(byte[] bytes, int offset, int length) {
        Slime slime = new Slime();
        this.in = new BufferedInput(bytes, offset, length);
        this.decodeSymbolTable(slime);
        this.decodeValue(this.slimeInserter.adjust(slime));
        if (this.in.failed()) {
            slime.wrap("partial_result");
            slime.get().setData("offending_input", this.in.getOffending());
            slime.get().setString("error_message", this.in.getErrorMessage());
        }
        return slime;
    }

    long read_cmpr_long() {
        long next = this.in.getByte();
        long value = next & 0x7FL;
        int shift = 7;
        while ((next & 0x80L) != 0L) {
            next = this.in.getByte();
            value |= (next & 0x7FL) << shift;
            shift += 7;
        }
        return value;
    }

    long read_size(int meta) {
        return meta == 0 ? this.read_cmpr_long() : (long)(meta - 1);
    }

    long read_bytes_le(int bytes) {
        long value = 0L;
        int shift = 0;
        for (int i = 0; i < bytes; ++i) {
            long b = this.in.getByte();
            value |= (b & 0xFFL) << shift;
            shift += 8;
        }
        return value;
    }

    long read_bytes_be(int bytes) {
        long value = 0L;
        int shift = 56;
        for (int i = 0; i < bytes; ++i) {
            long b = this.in.getByte();
            value |= (b & 0xFFL) << shift;
            shift -= 8;
        }
        return value;
    }

    Cursor decodeNIX(Inserter inserter) {
        return inserter.insertNIX();
    }

    Cursor decodeBOOL(Inserter inserter, int meta) {
        return inserter.insertBOOL(meta != 0);
    }

    Cursor decodeLONG(Inserter inserter, int meta) {
        long encoded = this.read_bytes_le(meta);
        return inserter.insertLONG(BinaryFormat.decode_zigzag(encoded));
    }

    Cursor decodeDOUBLE(Inserter inserter, int meta) {
        long encoded = this.read_bytes_be(meta);
        return inserter.insertDOUBLE(BinaryFormat.decode_double(encoded));
    }

    Cursor decodeSTRING(Inserter inserter, int meta) {
        long size = this.read_size(meta);
        int sz = (int)size;
        byte[] image = this.in.getBytes(sz);
        return inserter.insertSTRING(image);
    }

    Cursor decodeDATA(Inserter inserter, int meta) {
        long size = this.read_size(meta);
        int sz = (int)size;
        byte[] image = this.in.getBytes(sz);
        return inserter.insertDATA(image);
    }

    Cursor decodeARRAY(Inserter inserter, int meta) {
        Cursor cursor = inserter.insertARRAY();
        long size = this.read_size(meta);
        int i = 0;
        while ((long)i < size) {
            this.decodeValue(this.arrayInserter.adjust(cursor));
            ++i;
        }
        return cursor;
    }

    Cursor decodeOBJECT(Inserter inserter, int meta) {
        Cursor cursor = inserter.insertOBJECT();
        long size = this.read_size(meta);
        int i = 0;
        while ((long)i < size) {
            long l = this.read_cmpr_long();
            int symbol = (int)l;
            this.decodeValue(this.objectInserter.adjust(cursor, symbol));
            ++i;
        }
        return cursor;
    }

    Cursor decodeValue(Inserter inserter, Type type, int meta) {
        switch (type) {
            case NIX: {
                return this.decodeNIX(inserter);
            }
            case BOOL: {
                return this.decodeBOOL(inserter, meta);
            }
            case LONG: {
                return this.decodeLONG(inserter, meta);
            }
            case DOUBLE: {
                return this.decodeDOUBLE(inserter, meta);
            }
            case STRING: {
                return this.decodeSTRING(inserter, meta);
            }
            case DATA: {
                return this.decodeDATA(inserter, meta);
            }
            case ARRAY: {
                return this.decodeARRAY(inserter, meta);
            }
            case OBJECT: {
                return this.decodeOBJECT(inserter, meta);
            }
        }
        assert (false) : "should not be reached";
        return null;
    }

    void decodeValue(Inserter inserter) {
        byte b = this.in.getByte();
        Cursor cursor = this.decodeValue(inserter, BinaryFormat.decode_type(b), BinaryFormat.decode_meta(b));
        if (!cursor.valid()) {
            this.in.fail("failed to decode value");
        }
    }

    void decodeSymbolTable(Slime slime) {
        long numSymbols = this.read_cmpr_long();
        byte[] backing = this.in.getBacking();
        int i = 0;
        while ((long)i < numSymbols) {
            long size = this.read_cmpr_long();
            int sz = (int)size;
            int offset = this.in.getPosition();
            this.in.skip(sz);
            int symbol = slime.insert(Utf8Codec.decode(backing, offset, sz));
            if (symbol != i) {
                this.in.fail("duplicate symbols in symbol table");
                return;
            }
            ++i;
        }
    }
}

