/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.protect;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Process {
    private static final Logger log = Logger.getLogger(Process.class.getName());

    public static void logAndDie(String message) {
        Process.logAndDie(message, null);
    }

    public static void logAndDie(String message, boolean dumpThreads) {
        Process.logAndDie(message, null, dumpThreads);
    }

    public static void logAndDie(String message, Throwable thrown) {
        Process.logAndDie(message, thrown, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logAndDie(String message, Throwable thrown, boolean dumpThreads) {
        try {
            if (dumpThreads) {
                log.log(Level.INFO, "About to shut down.");
                Process.dumpThreads();
            }
            if (thrown != null) {
                log.log(Level.SEVERE, message, thrown);
            } else {
                log.log(Level.SEVERE, message);
            }
        }
        finally {
            try {
                Runtime.getRuntime().halt(1);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Runtime.halt rejected. Throwing an error.");
                throw new ShutdownError("Shutdown requested, but failed to shut down");
            }
        }
    }

    public static void dumpThreads() {
        try {
            log.log(Level.INFO, "Commencing full thread dump for diagnosis.");
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> e : allStackTraces.entrySet()) {
                Thread t = e.getKey();
                StackTraceElement[] stack = e.getValue();
                StringBuilder forOneThread = new StringBuilder();
                forOneThread.append("Stack for thread: ").append(t.getName()).append(": ");
                for (StackTraceElement s : stack) {
                    forOneThread.append('\n').append(s.toString());
                }
                log.log(Level.INFO, forOneThread.toString());
            }
            log.log(Level.INFO, "End of diagnostic thread dump.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class ShutdownError
    extends Error {
        public ShutdownError(String message) {
            super(message);
        }
    }
}

