/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.javacc;

public class UnicodeUtilities {
    public static String quote(String str, char quote) {
        StringBuilder ret = new StringBuilder();
        ret.append(quote);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == quote) {
                ret.append("\\").append(c);
                continue;
            }
            ret.append(UnicodeUtilities.escape(c));
        }
        ret.append(quote);
        return ret.toString();
    }

    public static String unquote(String str) {
        if (str.length() == 0) {
            return str;
        }
        char quote = str.charAt(0);
        if (quote != '\"' && quote != '\'') {
            return str;
        }
        if (str.charAt(str.length() - 1) != quote) {
            return str;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 1; i < str.length() - 1; ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                if (++i == str.length() - 1) break;
                c = str.charAt(i);
                if (c == 'f') {
                    ret.append("\f");
                    continue;
                }
                if (c == 'n') {
                    ret.append("\n");
                    continue;
                }
                if (c == 'r') {
                    ret.append("\r");
                    continue;
                }
                if (c == 't') {
                    ret.append("\t");
                    continue;
                }
                if (c == 'u') {
                    if (++i > str.length() - 4) break;
                    try {
                        ret.append((char)Integer.parseInt(str.substring(i, i + 4), 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(e);
                    }
                    i += 3;
                    continue;
                }
                ret.append(c);
                continue;
            }
            if (c == quote) {
                throw new IllegalArgumentException();
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private static String escape(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (c < ' ' || c > '~') {
            String unicode = Integer.toString(c, 16);
            return "\\u" + "0000".substring(0, 4 - unicode.length()) + unicode + "";
        }
        return "" + c;
    }

    public static String generateToken(Predicate predicate) {
        TokenBuilder builder = new TokenBuilder();
        for (int c = 0; c <= 65535; ++c) {
            if (!predicate.accepts((char)c)) continue;
            builder.add(c);
        }
        return builder.build();
    }

    private static class TokenBuilder {
        final StringBuilder token = new StringBuilder();
        int prevC = -1;
        int fromC = 0;
        int charCnt = 0;

        private TokenBuilder() {
        }

        void add(int c) {
            if (this.prevC + 1 != c) {
                this.flushRange();
                this.fromC = c;
            }
            this.prevC = c;
        }

        void flushRange() {
            if (this.fromC > this.prevC) {
                return;
            }
            this.append(this.fromC);
            if (this.fromC < this.prevC) {
                this.token.append('-');
                this.append(this.prevC);
                ++this.charCnt;
            }
            this.token.append(',');
            if (++this.charCnt > 16) {
                this.token.append('\n');
                this.charCnt = 0;
            }
        }

        void append(int c) {
            this.token.append("\"");
            if (c == 10) {
                this.token.append("\\n");
            } else if (c == 13) {
                this.token.append("\\r");
            } else if (c == 34) {
                this.token.append("\\\"");
            } else if (c == 92) {
                this.token.append("\\\\");
            } else {
                this.token.append("\\u").append(String.format("%04x", c & 0xFFFF));
            }
            this.token.append("\"");
        }

        String build() {
            this.flushRange();
            return this.token.toString();
        }
    }

    public static interface Predicate {
        public boolean accepts(char var1);
    }
}

