/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.java7compat;

public class Util {
    private static final int javaVersion = Integer.valueOf(System.getProperty("java.version").substring(2, 3));

    public static boolean isJava7Compatible() {
        return javaVersion >= 7;
    }

    public static String toJava7String(double d) {
        String s = String.valueOf(d);
        if (!Util.isJava7Compatible()) {
            s = Util.nonJava7CompatibleString(s);
        }
        return s;
    }

    static String nonJava7CompatibleString(String s) {
        if (s.length() >= 3 && s.contains(".")) {
            int l;
            for (l = s.length(); l > 2 && s.charAt(l - 1) == '0' && s.charAt(l - 2) >= '0' && s.charAt(l - 1) <= '9'; --l) {
            }
            if (l != s.length()) {
                s = s.substring(0, l);
            }
        }
        return s;
    }
}

