/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent;

import com.yahoo.concurrent.LocalInstance;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ThreadLocalDirectory<AGGREGATOR, SAMPLE> {
    private final ThreadLocal<LocalInstance<AGGREGATOR, SAMPLE>> local = new ThreadLocal();
    private final Object directoryLock = new Object();
    private List<LocalInstance<AGGREGATOR, SAMPLE>> directory = new ArrayList<LocalInstance<AGGREGATOR, SAMPLE>>();
    private final Updater<AGGREGATOR, SAMPLE> updater;
    private final ObservableUpdater<AGGREGATOR, SAMPLE> observableUpdater;

    public ThreadLocalDirectory(Updater<AGGREGATOR, SAMPLE> updater) {
        this.updater = updater;
        this.observableUpdater = updater instanceof ObservableUpdater ? (ObservableUpdater)updater : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(LocalInstance<AGGREGATOR, SAMPLE> q) {
        q.setRegistered(true);
        Object object = this.directoryLock;
        synchronized (object) {
            this.directory.add(q);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AGGREGATOR> fetch() {
        List<LocalInstance<AGGREGATOR, SAMPLE>> previous;
        int previousIntervalSize;
        Iterator<LocalInstance<AGGREGATOR, SAMPLE>> iterator = this.directoryLock;
        synchronized (iterator) {
            previousIntervalSize = this.directory.size();
            previous = this.directory;
            this.directory = new ArrayList<LocalInstance<AGGREGATOR, SAMPLE>>(previousIntervalSize);
        }
        ArrayList<AGGREGATOR> contained = new ArrayList<AGGREGATOR>(previousIntervalSize);
        for (LocalInstance<AGGREGATOR, SAMPLE> x : previous) {
            contained.add(x.getAndReset(this.updater));
        }
        return contained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AGGREGATOR> view() {
        ArrayList<LocalInstance<AGGREGATOR, SAMPLE>> current;
        if (this.observableUpdater == null) {
            throw new IllegalStateException("Does not use observable updaters.");
        }
        Iterator iterator = this.directoryLock;
        synchronized (iterator) {
            current = new ArrayList<LocalInstance<AGGREGATOR, SAMPLE>>(this.directory);
        }
        ArrayList<AGGREGATOR> view = new ArrayList<AGGREGATOR>(current.size());
        for (LocalInstance localInstance : current) {
            view.add(localInstance.copyCurrent(this.observableUpdater));
        }
        return view;
    }

    private LocalInstance<AGGREGATOR, SAMPLE> getOrCreateLocal() {
        LocalInstance<AGGREGATOR, SAMPLE> current = this.local.get();
        if (current == null) {
            current = new LocalInstance<AGGREGATOR, SAMPLE>(this.updater);
            this.local.set(current);
        }
        return current;
    }

    public LocalInstance<AGGREGATOR, SAMPLE> getLocalInstance() {
        return this.getOrCreateLocal();
    }

    public void update(SAMPLE x) {
        this.update(x, this.getOrCreateLocal());
    }

    public void update(SAMPLE x, LocalInstance<AGGREGATOR, SAMPLE> localInstance) {
        boolean isRegistered = localInstance.update(x, this.updater);
        if (!isRegistered) {
            this.put(localInstance);
        }
    }

    public static interface ObservableUpdater<AGGREGATOR, SAMPLE>
    extends Updater<AGGREGATOR, SAMPLE> {
        public AGGREGATOR copy(AGGREGATOR var1);
    }

    public static interface Updater<AGGREGATOR, SAMPLE> {
        public AGGREGATOR createGenerationInstance(AGGREGATOR var1);

        public AGGREGATOR update(AGGREGATOR var1, SAMPLE var2);
    }
}

