/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import com.yahoo.text.Utf8;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5 {
    public static final ThreadLocal<MessageDigest> md5 = new MD5Factory();
    private final MessageDigest digester;

    private static MessageDigest createMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public MD5() {
        try {
            this.digester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"MD5 algorithm not found.");
        }
    }

    public int hash(String s) {
        byte[] md5 = this.digester.digest(Utf8.toBytes(s));
        int hash = 0;
        assert (md5.length == 16);
        int byte1 = md5[12] << 24 & 0xFF000000;
        int byte2 = md5[13] << 16 & 0xFF0000;
        int byte3 = md5[14] << 8 & 0xFF00;
        int byte4 = md5[15] & 0xFF;
        hash |= byte1;
        hash |= byte2;
        hash |= byte3;
        return hash |= byte4;
    }

    public byte[] hashFull(String s) {
        return this.digester.digest(Utf8.toBytes(s));
    }

    private static class MD5Factory
    extends ThreadLocal<MessageDigest> {
        private MD5Factory() {
        }

        @Override
        protected MessageDigest initialValue() {
            return MD5.createMD5();
        }
    }
}

