/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool.crypto;

import com.yahoo.security.KeyId;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SealedSharedKey;
import com.yahoo.security.SecretSharedKey;
import com.yahoo.security.SharedKeyGenerator;
import com.yahoo.vespa.security.tool.CliUtils;
import com.yahoo.vespa.security.tool.Tool;
import com.yahoo.vespa.security.tool.ToolDescription;
import com.yahoo.vespa.security.tool.ToolInvocation;
import com.yahoo.vespa.security.tool.crypto.ToolUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.util.List;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class ResealTool
implements Tool {
    static final String PRIVATE_KEY_FILE_OPTION = "private-key-file";
    static final String EXPECTED_KEY_ID_OPTION = "expected-key-id";
    static final String RECIPIENT_KEY_ID_OPTION = "key-id";
    static final String RECIPIENT_PUBLIC_KEY_OPTION = "recipient-public-key";
    private static final List<Option> OPTIONS = List.of(Option.builder((String)"k").longOpt("private-key-file").hasArg(true).required(false).desc("Private key file in Base58 encoded format").build(), Option.builder((String)"e").longOpt("expected-key-id").hasArg(true).required(false).desc("Expected key ID in token. If this is not provided, the key ID is not verified.").build(), Option.builder((String)"r").longOpt("recipient-public-key").hasArg(true).required(false).desc("Recipient X25519 public key in Base58 encoded format").build(), Option.builder((String)"i").longOpt("key-id").hasArg(true).required(false).desc("ID of recipient key").build());

    @Override
    public String name() {
        return "reseal";
    }

    @Override
    public ToolDescription description() {
        return new ToolDescription("<token> <options>", "Reseals the input token for another recipient, allowing that recipient to decrypt the file that the input token was originally created for.\nPrints new token to STDOUT.", "Note: this is a BETA tool version; its interface may be changed at any time", OPTIONS);
    }

    @Override
    public int invoke(ToolInvocation invocation) {
        try {
            CommandLine arguments = invocation.arguments();
            String[] leftoverArgs = arguments.getArgs();
            if (leftoverArgs.length != 1) {
                throw new IllegalArgumentException("Expected exactly 1 token argument to re-seal");
            }
            String tokenString = leftoverArgs[0];
            Optional<Object> maybeKeyId = Optional.ofNullable(arguments.hasOption(EXPECTED_KEY_ID_OPTION) ? arguments.getOptionValue(EXPECTED_KEY_ID_OPTION) : null);
            SealedSharedKey sealedSharedKey = SealedSharedKey.fromTokenString((String)tokenString.strip());
            ToolUtils.verifyExpectedKeyId(sealedSharedKey, maybeKeyId);
            XECPublicKey recipientPubKey = KeyUtils.fromBase58EncodedX25519PublicKey((String)CliUtils.optionOrThrow(arguments, RECIPIENT_PUBLIC_KEY_OPTION).strip());
            KeyId recipientKeyId = KeyId.ofString((String)CliUtils.optionOrThrow(arguments, RECIPIENT_KEY_ID_OPTION));
            Path privKeyPath = Paths.get(CliUtils.optionOrThrow(arguments, PRIVATE_KEY_FILE_OPTION), new String[0]);
            XECPrivateKey privateKey = KeyUtils.fromBase58EncodedX25519PrivateKey((String)Files.readString(privKeyPath).strip());
            SecretSharedKey secretShared = SharedKeyGenerator.fromSealedKey((SealedSharedKey)sealedSharedKey, (PrivateKey)privateKey);
            SecretSharedKey resealedShared = SharedKeyGenerator.reseal((SecretSharedKey)secretShared, (PublicKey)recipientPubKey, (KeyId)recipientKeyId);
            invocation.stdOut().println(resealedShared.sealedSharedKey().toTokenString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }
}

