/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool.crypto;

import com.yahoo.security.KeyUtils;
import com.yahoo.vespa.security.tool.CliUtils;
import com.yahoo.vespa.security.tool.Tool;
import com.yahoo.vespa.security.tool.ToolDescription;
import com.yahoo.vespa.security.tool.ToolInvocation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.KeyPair;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class KeygenTool
implements Tool {
    static final String PRIVATE_OUT_FILE_OPTION = "private-out-file";
    static final String PUBLIC_OUT_FILE_OPTION = "public-out-file";
    static final String OVERWRITE_EXISTING_OPTION = "overwrite-existing";
    private static final List<Option> OPTIONS = List.of(Option.builder((String)"k").longOpt("private-out-file").hasArg(true).required(false).desc("Output file for private (secret) key. Will be created with restrictive file permissions.").build(), Option.builder((String)"p").longOpt("public-out-file").hasArg(true).required(false).desc("Output file for public key").build(), Option.builder().longOpt("overwrite-existing").hasArg(false).required(false).desc("Overwrite existing key files instead of failing key generation if any files already exist. Use with great caution!").build());

    @Override
    public String name() {
        return "keygen";
    }

    @Override
    public ToolDescription description() {
        return new ToolDescription("<options>", "Generates an X25519 key pair and stores its private/public parts in separate files in Base64 encoded form.", "Note: this is a BETA tool version; its interface may be changed at any time", OPTIONS);
    }

    private void handleExistingFileIfAny(Path filePath, boolean allowOverwrite) throws IOException {
        if (filePath.toFile().exists()) {
            if (!allowOverwrite) {
                throw new IllegalArgumentException("Output file '%s' already exists. No keys written. If you want to overwrite existing files, specify --%s.".formatted(filePath.toAbsolutePath().toString(), OVERWRITE_EXISTING_OPTION));
            }
            Files.delete(filePath);
        }
    }

    @Override
    public int invoke(ToolInvocation invocation) {
        try {
            CommandLine arguments = invocation.arguments();
            Path privOutPath = Paths.get(CliUtils.optionOrThrow(arguments, PRIVATE_OUT_FILE_OPTION), new String[0]);
            Path pubOutPath = Paths.get(CliUtils.optionOrThrow(arguments, PUBLIC_OUT_FILE_OPTION), new String[0]);
            boolean allowOverwrite = arguments.hasOption(OVERWRITE_EXISTING_OPTION);
            this.handleExistingFileIfAny(privOutPath, allowOverwrite);
            this.handleExistingFileIfAny(pubOutPath, allowOverwrite);
            KeyPair keyPair = KeyUtils.generateX25519KeyPair();
            XECPrivateKey privKey = (XECPrivateKey)keyPair.getPrivate();
            XECPublicKey pubKey = (XECPublicKey)keyPair.getPublic();
            Set<PosixFilePermission> privFilePerms = PosixFilePermissions.fromString("rw-------");
            Files.createFile(privOutPath, PosixFilePermissions.asFileAttribute(privFilePerms));
            Files.writeString(privOutPath, (CharSequence)(KeyUtils.toBase64EncodedX25519PrivateKey((XECPrivateKey)privKey) + "\n"), new OpenOption[0]);
            Files.writeString(pubOutPath, (CharSequence)(KeyUtils.toBase64EncodedX25519PublicKey((XECPublicKey)pubKey) + "\n"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }
}

