/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.merge;

import ai.vespa.vespasignificance.common.VespaSignificanceTsvReader;
import ai.vespa.vespasignificance.common.VespaSignificanceTsvWriter;
import ai.vespa.vespasignificance.merge.HalfSystemLimitBudget;
import ai.vespa.vespasignificance.merge.MergeClientParameters;
import ai.vespa.vespasignificance.merge.TermDfExternalMerger;
import com.yahoo.vespasignificance.CommandLineOptions;
import io.airlift.compress.zstd.ZstdInputStream;
import io.airlift.compress.zstd.ZstdOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class MergeCommand {
    private final MergeClientParameters params;
    private Path outputPath;
    private final List<Path> inputPaths = new ArrayList<Path>();

    public MergeCommand(MergeClientParameters params) {
        this.params = params;
    }

    public int run() {
        try {
            this.prepareOutputPath();
            this.resolveAndValidateInputs();
            this.ensureOutputNotInInputs();
            long totalDocCount = 0L;
            for (Path p : this.inputPaths) {
                VespaSignificanceTsvReader.Header h = this.readHeader(p);
                totalDocCount += h.documentCount();
            }
            TermDfExternalMerger merger = new TermDfExternalMerger(new HalfSystemLimitBudget(), this.inputPaths, MergeCommand::openInputReader);
            OutputStream output = Files.newOutputStream(this.outputPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            BufferedOutputStream bos = new BufferedOutputStream(output, 65536);
            BufferedOutputStream os = this.params.zstCompress() ? new ZstdOutputStream((OutputStream)bos) : bos;
            OutputStreamWriter ow = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
            try (VespaSignificanceTsvWriter vstsv = new VespaSignificanceTsvWriter(ow, totalDocCount, true, Instant.now());){
                merger.mergeFiles(vstsv::writeRow, this.params.minKeep());
                vstsv.flush();
            }
            System.out.println("Merged files to " + String.valueOf(this.outputPath));
        }
        catch (MergeFailure ignored) {
            return 1;
        }
        catch (IOException e) {
            System.err.println("I/O error while merging: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private void prepareOutputPath() {
        Object out = this.params.outputFile();
        if (out == null || ((String)out).isBlank()) {
            out = "merged.vstsv";
        }
        boolean wantsZst = this.params.zstCompress();
        boolean hasZstSuffix = ((String)out).endsWith(".zst");
        if (wantsZst && !hasZstSuffix) {
            out = (String)out + ".zst";
        }
        this.outputPath = Path.of((String)out, new String[0]);
        Path parent = this.outputPath.getParent();
        if (parent != null) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.err.println("Error: Unable to create parent directory for output: " + String.valueOf(parent));
                throw new MergeFailure();
            }
        }
    }

    private void resolveAndValidateInputs() {
        if (this.params.inputFiles().isEmpty()) {
            System.err.println("Error: No input files specified.");
            CommandLineOptions.printMergeHelp();
            throw new MergeFailure();
        }
        for (String input : this.params.inputFiles()) {
            Path path = Path.of(input, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                System.err.println("Error: Input file " + input + " does not exist.");
                throw new MergeFailure();
            }
            this.inputPaths.add(path);
        }
    }

    private void ensureOutputNotInInputs() {
        if (this.outputPath != null && this.inputPaths.stream().map(p -> p.toAbsolutePath().normalize()).anyMatch(p -> p.equals(this.outputPath.toAbsolutePath().normalize()))) {
            System.err.println("Error: Output file must be different from all input files: " + String.valueOf(this.outputPath));
            throw new MergeFailure();
        }
    }

    private static BufferedReader openInputReader(Path path) throws IOException {
        String line;
        String name = path.getFileName().toString().toLowerCase(Locale.ROOT);
        InputStream in = Files.newInputStream(path, new OpenOption[0]);
        BufferedInputStream bin = new BufferedInputStream(in, 65536);
        BufferedInputStream decoded = name.endsWith(".zst") ? new ZstdInputStream((InputStream)bin) : bin;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)decoded, StandardCharsets.UTF_8), 65536);
        while ((line = br.readLine()) != null && !Objects.equals(line, "--END-HEADER--")) {
        }
        return br;
    }

    private VespaSignificanceTsvReader.Header readHeader(Path path) throws IOException {
        String name = path.getFileName().toString().toLowerCase(Locale.ROOT);
        InputStream in = Files.newInputStream(path, new OpenOption[0]);
        BufferedInputStream bin = new BufferedInputStream(in);
        BufferedInputStream decoded = name.endsWith(".zst") ? new ZstdInputStream((InputStream)bin) : bin;
        try (VespaSignificanceTsvReader r = new VespaSignificanceTsvReader(new InputStreamReader((InputStream)decoded, StandardCharsets.UTF_8));){
            VespaSignificanceTsvReader.Header header = r.header();
            return header;
        }
    }

    private static BufferedWriter newOutputWriter(Path output, boolean zst) throws IOException {
        OutputStream out = Files.newOutputStream(output, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        if (zst) {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new ZstdOutputStream((OutputStream)new BufferedOutputStream(out)), StandardCharsets.UTF_8));
        }
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), StandardCharsets.UTF_8));
    }

    static final class MergeFailure
    extends RuntimeException {
        MergeFailure() {
        }
    }
}

