/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.export;

import ai.vespa.vespasignificance.export.DocIdLimitDocumentCountProvider;
import ai.vespa.vespasignificance.export.DocumentCountProvider;
import ai.vespa.vespasignificance.export.ExportClientParameters;
import ai.vespa.vespasignificance.export.IndexLocator;
import ai.vespa.vespasignificance.export.PathSelector;
import ai.vespa.vespasignificance.export.SelectionException;
import ai.vespa.vespasignificance.export.SignificanceTsvDfWriter;
import ai.vespa.vespasignificance.export.TablePrinter;
import ai.vespa.vespasignificance.export.TermDfWriter;
import ai.vespa.vespasignificance.export.VespaFileHeaderInspectClient;
import ai.vespa.vespasignificance.export.VespaIndexInspectClient;
import com.yahoo.vespasignificance.CommandLineOptions;
import io.airlift.compress.zstd.ZstdOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class Export {
    private final ExportClientParameters params;
    private final IndexLocator locator;
    private final WriterFactory writerFactory;
    private final DumpFn dumpFn;
    private final DocumentCountProviderFactory docCountFactory;
    private Path indexDir;
    private String fieldName;
    private Path outputPath;

    public Export(ExportClientParameters params) {
        this(params, new IndexLocator(), SignificanceTsvDfWriter::new, (idx, field) -> new VespaIndexInspectClient().streamDumpWords(idx, field), dir -> new DocIdLimitDocumentCountProvider(new VespaFileHeaderInspectClient(), dir));
    }

    Export(ExportClientParameters params, IndexLocator locator, WriterFactory writerFactory, DumpFn dumpFn, DocumentCountProviderFactory docCountFactory) {
        this.params = Objects.requireNonNull(params);
        this.locator = Objects.requireNonNull(locator);
        this.writerFactory = Objects.requireNonNull(writerFactory);
        this.dumpFn = Objects.requireNonNull(dumpFn);
        this.docCountFactory = docCountFactory;
    }

    public int run() {
        try {
            this.ensureOutputFile();
            this.resolveIndexDir();
            this.requireFieldDir(this.params.fieldName());
            long documentCount = this.docCountFactory.create(this.indexDir).getDocumentCount();
            boolean sorted = true;
            Instant createdAt = Instant.now();
            try (OutputStream output = Files.newOutputStream(this.outputPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                 Object maybeCompressed = this.params.zstCompress() ? new ZstdOutputStream((OutputStream)new BufferedOutputStream(output)) : new BufferedOutputStream(output);
                 Stream<VespaIndexInspectClient.TermDocumentFrequency> rows = this.dumpFn.open(this.indexDir, this.fieldName).sorted(Comparator.comparing(VespaIndexInspectClient.TermDocumentFrequency::term));
                 TermDfWriter writer = this.writerFactory.create(new OutputStreamWriter((OutputStream)maybeCompressed, StandardCharsets.UTF_8), documentCount, sorted, createdAt);){
                writer.writeAll(rows);
                writer.flush();
            }
            System.out.println("Exported " + String.valueOf(Path.of(this.indexDir.toString(), this.fieldName)) + " to " + String.valueOf(this.outputPath.toAbsolutePath()));
            return 0;
        }
        catch (ExportFailure ignored) {
            return 1;
        }
        catch (IOException e) {
            System.err.println("Error during export: " + e.getMessage());
            return 1;
        }
    }

    private void ensureOutputFile() {
        Object out = this.params.outputFile();
        if (out == null || ((String)out).isBlank()) {
            out = "export_" + this.params.fieldName() + ".vstsv";
        }
        boolean wantsZst = this.params.zstCompress();
        boolean hasZstSuffix = ((String)out).endsWith(".zst");
        if (wantsZst && !hasZstSuffix) {
            out = (String)out + ".zst";
        }
        this.outputPath = Path.of((String)out, new String[0]);
        Path parent = this.outputPath.getParent();
        if (parent != null) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.err.println("Error: Unable to create parent directory for output: " + String.valueOf(parent));
                throw new ExportFailure();
            }
        }
    }

    private void resolveIndexDir() {
        if (this.params.indexDir() == null) {
            try {
                this.indexDir = this.locator.locateIndexDir(this.params.clusterName().orElse(null), this.params.schemaName().orElse(null), this.params.nodeIndex().orElse(null));
            }
            catch (SelectionException e) {
                this.handleSelectionException(e);
            }
            catch (NoSuchFileException nf) {
                System.err.println(nf.getMessage());
                System.err.println("Note: you can use --index-dir to specify the index directory.");
                throw new ExportFailure();
            }
        } else {
            if (this.params.indexDir().isEmpty()) {
                System.err.println("Error: No index directory specified.");
                System.err.println("Use --index-dir to specify index directory.");
                CommandLineOptions.printExportHelp();
                throw new ExportFailure();
            }
            Path explicit = Path.of(this.params.indexDir(), new String[0]);
            if (!Files.isDirectory(explicit, new LinkOption[0])) {
                System.err.println("Error: Index directory `" + String.valueOf(explicit) + "` does not exist or is not a directory.");
                throw new ExportFailure();
            }
            this.indexDir = explicit;
        }
    }

    private void requireFieldDir(String fieldName) {
        List<Path> fieldDirs;
        if (!Files.isDirectory(this.indexDir, new LinkOption[0])) {
            System.err.println("Error: Index directory `" + String.valueOf(this.indexDir) + "` does not exist or is not a directory.");
            throw new ExportFailure();
        }
        try (Stream<Path> s = Files.list(this.indexDir);){
            fieldDirs = s.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toList();
        }
        catch (IOException e) {
            System.err.println("Failed to list index directory: " + String.valueOf(this.indexDir) + " (" + e.getMessage() + ")");
            throw new ExportFailure();
        }
        PathSelector.Result<Path> res = PathSelector.selectOne(fieldDirs, fieldName, "field", this.indexDir, p -> p.getFileName().toString(), Path::toString);
        if (res.outcome() == PathSelector.Outcome.CHOSEN) {
            this.fieldName = Objects.requireNonNull(res.value()).getFileName().toString();
            return;
        }
        this.handleSelectionException(new SelectionException(res.outcome(), "field", res.message(), res.options()));
    }

    private void handleSelectionException(SelectionException e) {
        System.err.println("Error: " + e.getMessage());
        List<PathSelector.Row> rows = e.options();
        if (!rows.isEmpty()) {
            TablePrinter.printTable(System.err, null, List.of(e.kind(), "path"), rows.stream().map(r -> List.of(r.name(), r.path())).toList());
            System.err.println();
            System.err.println("Use `--" + e.kind() + " <name>` to select one of the above.");
        }
        throw new ExportFailure();
    }

    @FunctionalInterface
    static interface WriterFactory {
        public TermDfWriter create(Writer var1, long var2, boolean var4, Instant var5) throws IOException;
    }

    @FunctionalInterface
    static interface DumpFn {
        public Stream<VespaIndexInspectClient.TermDocumentFrequency> open(Path var1, String var2) throws IOException;
    }

    @FunctionalInterface
    static interface DocumentCountProviderFactory {
        public DocumentCountProvider create(Path var1);
    }

    static final class ExportFailure
    extends RuntimeException {
        ExportFailure() {
        }
    }
}

