/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespasignificance;

import ai.vespa.vespasignificance.export.ExportClientParameters;
import ai.vespa.vespasignificance.merge.MergeClientParameters;
import com.yahoo.vespasignificance.ClientParameters;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CommandLineOptions {
    public static final String HELP_OPTION = "help";
    public static final String INPUT_OPTION = "in";
    public static final String OUTPUT_OPTION = "out";
    public static final String FIELD_OPTION = "field";
    public static final String LANGUAGE_OPTION = "language";
    public static final String ZST_COMPRESSION = "zst-compression";
    public static final String FORMAT_OPTION = "format";
    public static final String INDEX_DIR = "index-dir";
    public static final String CLUSTER_OPTION = "cluster";
    public static final String SCHEMA_NAME = "schema";
    public static final String NODE_INDEX_OPTION = "node-index";
    public static final String MIN_KEEP_OPTION = "min-keep";

    static Options createGlobalOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt(HELP_OPTION).desc("Show available commands.").build());
        return options;
    }

    static Map<String, String> registeredCommands() {
        LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
        commands.put("generate", "Generate a significance model from a JSONL feed file or a Vespa Significance TSV file.");
        commands.put("export", "Export terms and document frequency from an index to a Vespa Significance TSV file.");
        commands.put("merge", "Merge multiple Vespa Significance TSV files.");
        return commands;
    }

    static void printGlobalHelp() {
        HelpFormatter fmt = new HelpFormatter();
        fmt.setWidth(120);
        fmt.setLeftPadding(2);
        fmt.setOptionComparator(Comparator.comparing(Option::getLongOpt));
        Comparator byName = String.CASE_INSENSITIVE_ORDER;
        StringBuilder header = new StringBuilder("Commands:\n");
        CommandLineOptions.registeredCommands().entrySet().stream().sorted(Map.Entry.comparingByKey(byName)).forEach(e -> header.append(String.format("  %-12s %s%n", e.getKey(), e.getValue())));
        header.append("\nOptions:");
        fmt.printHelp("vespa-significance <command> [options]", header.toString(), CommandLineOptions.createGlobalOptions(), "", false);
    }

    static Options createGenerateOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt(HELP_OPTION).desc("Show this help and exit.").build());
        options.addOption(Option.builder((String)"i").longOpt(INPUT_OPTION).required().hasArg().argName("FILE").desc("Input JSON Lines. One Vespa document per line. Or Vespa Significance TSV (requires --format vstsv).").build());
        options.addOption(Option.builder().longOpt(FORMAT_OPTION).hasArg().argName("jsonl/vstsv").desc("Format of input file. Default is jsonl.").build());
        options.addOption(Option.builder((String)"o").longOpt(OUTPUT_OPTION).hasArg().argName("model.json[.zst]").desc("Output model file.").build());
        options.addOption(Option.builder((String)"f").longOpt(FIELD_OPTION).hasArg().argName("fieldName").desc("Document field to analyze.").build());
        options.addOption(Option.builder((String)"l").longOpt(LANGUAGE_OPTION).hasArg().argName("tag[,tag...]").desc("ISO language tag(s), comma-separated (e.g., 'en', 'no', or 'en,no').").build());
        options.addOption(Option.builder((String)"zst").longOpt(ZST_COMPRESSION).hasArg().argName("true|false").desc("Use Zstandard compression on output (default: false). If true, --out must end with .zst.").build());
        return options;
    }

    public static void printGenerateHelp() {
        HelpFormatter fmt = new HelpFormatter();
        fmt.setWidth(120);
        fmt.setLeftPadding(2);
        fmt.setDescPadding(2);
        fmt.setOptionComparator(Comparator.comparing(Option::getLongOpt));
        String header = "Options:";
        String footer = "Examples:\n  vespa-significance generate --in documents.jsonl --languages en,no --out model.json --field my_field\n  vespa-significance generate --format vstsv --in data.vstsv --out model.json\n";
        fmt.printHelp("vespa-significance generate [options] --in <FILE>", header, CommandLineOptions.createGenerateOptions(), footer, false);
    }

    public static ClientParameters parseGenerateCommandLineArguments(CommandLine cl) {
        ClientParameters.Builder builder = new ClientParameters.Builder();
        builder.setHelp(cl.hasOption(HELP_OPTION));
        builder.setInputFile(cl.getOptionValue(INPUT_OPTION));
        builder.setFormat(cl.hasOption(FORMAT_OPTION) ? cl.getOptionValue(FORMAT_OPTION) : "jsonl");
        builder.setOutputFile(cl.getOptionValue(OUTPUT_OPTION));
        builder.setField(cl.getOptionValue(FIELD_OPTION));
        builder.setLanguage(cl.getOptionValue(LANGUAGE_OPTION));
        builder.setZstCompression(cl.hasOption(ZST_COMPRESSION) ? cl.getOptionValue(ZST_COMPRESSION) : "false");
        return builder.build();
    }

    static Options createExportOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt(HELP_OPTION).desc("Show this help and exit.").build());
        options.addOption(Option.builder().longOpt(INDEX_DIR).hasArg().argName("path/to/index").desc("Path to index directory.").build());
        options.addOption(Option.builder().longOpt(OUTPUT_OPTION).hasArg().argName("FILE.vstsv[.zst]").desc("Output Vespa Significance TSV file.").build());
        options.addOption(Option.builder().longOpt(FIELD_OPTION).required().hasArg().argName("FIELD").desc("Field to export.").build());
        options.addOption(Option.builder().longOpt(CLUSTER_OPTION).hasArg().argName("NAME").desc("Cluster name.").build());
        options.addOption(Option.builder().longOpt(SCHEMA_NAME).hasArg().argName("NAME").desc("Schema name (document type).").build());
        options.addOption(Option.builder().longOpt(NODE_INDEX_OPTION).hasArg().argName("NUMBER").desc("Node index directory.").build());
        options.addOption(Option.builder((String)"zst").longOpt(ZST_COMPRESSION).desc("Use Zstandard compression on output.").build());
        return options;
    }

    public static void printExportHelp() {
        HelpFormatter fmt = new HelpFormatter();
        fmt.setWidth(100);
        fmt.setLeftPadding(2);
        fmt.setDescPadding(2);
        fmt.setOptionComparator(Comparator.comparing(Option::getLongOpt));
        String header = "Options:";
        fmt.printHelp("vespa-significance export [options] --field <FIELD>", header, CommandLineOptions.createExportOptions(), "", false);
    }

    public static ExportClientParameters parseExportCommandLineArguments(CommandLine cl) {
        return ExportClientParameters.builder().fieldName(cl.getOptionValue(FIELD_OPTION)).outputFile(cl.getOptionValue(OUTPUT_OPTION)).indexDir(cl.getOptionValue(INDEX_DIR)).clusterName(cl.getOptionValue(CLUSTER_OPTION)).schemaName(cl.getOptionValue(SCHEMA_NAME)).nodeIndex(cl.getOptionValue(NODE_INDEX_OPTION)).zstCompress(cl.hasOption(ZST_COMPRESSION)).build();
    }

    static Options createMergeOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt(HELP_OPTION).desc("Show this help and exit.").build());
        options.addOption(Option.builder().longOpt(OUTPUT_OPTION).hasArg().argName("FILE.vstsv[.zst]").desc("Output Vespa Significance TSV file.").build());
        options.addOption(Option.builder().longOpt(MIN_KEEP_OPTION).hasArg().argName("NUMBER").desc("Filter out documents with frequency lower than NUMBER.").build());
        options.addOption(Option.builder((String)"zst").longOpt(ZST_COMPRESSION).desc("Use Zstandard compression on output.").build());
        return options;
    }

    public static void printMergeHelp() {
        HelpFormatter fmt = new HelpFormatter();
        fmt.setWidth(100);
        fmt.setLeftPadding(2);
        fmt.setDescPadding(2);
        fmt.setOptionComparator(Comparator.comparing(Option::getLongOpt));
        String cmd = "vespa-significance merge [options] <input.vstsv[.zst]> [<input2.vstsv[.zst]> ...]";
        String header = "Options:";
        fmt.printHelp(cmd, header, CommandLineOptions.createMergeOptions(), "", false);
    }

    public static MergeClientParameters parseMergeCommandLineArguments(CommandLine cl) {
        return MergeClientParameters.builder().outputFile(cl.getOptionValue(OUTPUT_OPTION)).zstCompress(cl.hasOption(ZST_COMPRESSION)).minKeep(cl.hasOption(MIN_KEEP_OPTION) ? Long.parseLong(cl.getOptionValue(MIN_KEEP_OPTION)) : Long.MIN_VALUE).addInputFiles(cl.getArgList()).build();
    }

    static class Utils {
        Utils() {
        }

        static boolean hasHelpOption(String[] args) {
            for (String arg : args) {
                if (!List.of("--help", "-h").contains(arg)) continue;
                return true;
            }
            return false;
        }
    }
}

