/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespaget;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.documentapi.SyncParameters;
import com.yahoo.documentapi.messagebus.MessageBusDocumentAccess;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.MessageBusSyncSession;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentReply;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.Trace;
import com.yahoo.text.Utf8;
import com.yahoo.vespaclient.ClusterDef;
import com.yahoo.vespaclient.ClusterList;
import com.yahoo.vespaget.ClientParameters;
import com.yahoo.vespaget.DocumentAccessFactory;
import com.yahoo.vespaget.DocumentRetrieverException;
import java.util.Iterator;

public class DocumentRetriever {
    private final ClusterList clusterList;
    private final DocumentAccessFactory documentAccessFactory;
    private final ClientParameters params;
    private MessageBusSyncSession session;
    private MessageBusDocumentAccess documentAccess;

    public DocumentRetriever(ClusterList clusterList, DocumentAccessFactory documentAccessFactory, ClientParameters params) {
        this.clusterList = clusterList;
        this.documentAccessFactory = documentAccessFactory;
        this.params = params;
    }

    public void shutdown() {
        try {
            if (this.session != null) {
                this.session.destroy();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            if (this.documentAccess != null) {
                this.documentAccess.shutdown();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void retrieveDocuments() throws DocumentRetrieverException {
        boolean first = true;
        String route = this.params.cluster.isEmpty() ? this.params.route : this.resolveClusterRoute(this.params.cluster);
        MessageBusParams messageBusParams = this.createMessageBusParams(this.params.configId, this.params.timeout, route);
        this.documentAccess = this.documentAccessFactory.createDocumentAccess(messageBusParams);
        this.session = this.documentAccess.createSyncSession(new SyncParameters.Builder().build());
        int trace = this.params.traceLevel;
        if (trace > 0) {
            this.session.setTraceLevel(trace);
        }
        Iterator<String> iter = this.params.documentIds;
        if (this.params.jsonOutput && !this.params.printIdsOnly) {
            System.out.println('[');
        }
        while (iter.hasNext()) {
            if (this.params.jsonOutput && !this.params.printIdsOnly) {
                if (!first) {
                    System.out.println(',');
                } else {
                    first = false;
                }
            }
            String docid = iter.next();
            Message msg = this.createDocumentRequest(docid);
            Reply reply = this.session.syncSend(msg);
            this.printReply(reply);
        }
        if (this.params.jsonOutput && !this.params.printIdsOnly) {
            System.out.println(']');
        }
    }

    private String resolveClusterRoute(String clusterName) throws DocumentRetrieverException {
        if (this.clusterList.getStorageClusters().isEmpty()) {
            throw new DocumentRetrieverException("The Vespa cluster does not have any content clusters declared.");
        }
        ClusterDef clusterDef = null;
        for (ClusterDef c : this.clusterList.getStorageClusters()) {
            if (!c.getName().equals(clusterName)) continue;
            clusterDef = c;
        }
        if (clusterDef == null) {
            String names = this.createClusterNamesString();
            throw new DocumentRetrieverException(String.format("The Vespa cluster contains the content clusters %s, not %s. Please select a valid vespa cluster.", names, clusterName));
        }
        return clusterDef.getRoute();
    }

    private MessageBusParams createMessageBusParams(String configId, double timeout, String route) {
        MessageBusParams messageBusParams = new MessageBusParams();
        messageBusParams.setRoute(route);
        messageBusParams.setProtocolConfigId(configId);
        messageBusParams.setRoutingConfigId(configId);
        messageBusParams.setDocumentManagerConfigId(configId);
        if (timeout > 0.0) {
            messageBusParams.getSourceSessionParams().setTimeout(timeout);
        }
        return messageBusParams;
    }

    private Message createDocumentRequest(String docid) {
        GetDocumentMessage msg = new GetDocumentMessage(new DocumentId(docid), this.params.fieldSet);
        msg.setPriority(this.params.priority);
        msg.setRetryEnabled(!this.params.noRetry);
        return msg;
    }

    private void printReply(Reply reply) {
        Trace trace = reply.getTrace();
        if (!trace.getRoot().isEmpty()) {
            System.out.println(trace);
        }
        if (reply.hasErrors()) {
            System.err.print("Request failed: ");
            for (int i = 0; i < reply.getNumErrors(); ++i) {
                System.err.printf("\n  %s", reply.getError(i));
            }
            System.err.println();
            return;
        }
        if (!(reply instanceof GetDocumentReply)) {
            System.err.printf("Unexpected reply %s: '%s'\n", reply.getType(), reply.toString());
            return;
        }
        GetDocumentReply documentReply = (GetDocumentReply)reply;
        Document document = documentReply.getDocument();
        if (document == null) {
            System.out.println("Document not found.");
            return;
        }
        if (this.params.showDocSize) {
            System.out.printf("Document size: %d bytes.\n", document.getSerializedSize());
        }
        if (this.params.printIdsOnly) {
            System.out.println(document.getId());
        } else if (this.params.jsonOutput) {
            System.out.print(Utf8.toString((byte[])JsonWriter.toByteArray((Document)document, (boolean)this.params.tensorShortForm)));
        } else {
            System.out.print(document.toXML("  "));
        }
    }

    private String createClusterNamesString() {
        StringBuilder names = new StringBuilder();
        for (ClusterDef c : this.clusterList.getStorageClusters()) {
            if (names.length() > 0) {
                names.append(", ");
            }
            names.append(c.getName());
        }
        return names.toString();
    }
}

