/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespavisit;

import com.yahoo.document.BucketId;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.documentapi.AckToken;
import com.yahoo.documentapi.DumpVisitorDataHandler;
import com.yahoo.documentapi.ProgressToken;
import com.yahoo.documentapi.VisitorControlHandler;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.documentapi.messagebus.protocol.DocumentListEntry;
import com.yahoo.documentapi.messagebus.protocol.DocumentListMessage;
import com.yahoo.documentapi.messagebus.protocol.EmptyBucketsMessage;
import com.yahoo.documentapi.messagebus.protocol.MapVisitorMessage;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Message;
import com.yahoo.vespavisit.VdsVisitHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class StdOutVisitorHandler
extends VdsVisitHandler {
    private static final Logger log = Logger.getLogger(StdOutVisitorHandler.class.getName());
    private boolean printIds;
    private boolean indentXml;
    private int processTimeMilliSecs;
    private PrintStream out;
    private final boolean jsonOutput;
    private VisitorDataHandler dataHandler;

    public StdOutVisitorHandler(boolean printIds, boolean indentXml, boolean showProgress, boolean showStatistics, boolean doStatistics, boolean abortOnClusterDown, int processtime, boolean jsonOutput) {
        super(showProgress, showStatistics, abortOnClusterDown);
        this.printIds = printIds;
        this.indentXml = indentXml;
        this.processTimeMilliSecs = processtime;
        this.jsonOutput = jsonOutput;
        String charset = "UTF-8";
        try {
            this.out = new PrintStream((OutputStream)System.out, true, charset);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(charset + " is an unsupported encoding, using default instead.");
            this.out = System.out;
        }
        this.dataHandler = new DataHandler(doStatistics);
    }

    @Override
    public void onDone() {
    }

    @Override
    public VisitorDataHandler getDataHandler() {
        return this.dataHandler;
    }

    class ControlHandler
    extends VisitorControlHandler {
        ControlHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProgress(ProgressToken token) {
            if (StdOutVisitorHandler.this.showProgress) {
                Object object = StdOutVisitorHandler.this.printLock;
                synchronized (object) {
                    if (StdOutVisitorHandler.this.lastLineIsProgress) {
                        System.err.print('\r');
                    }
                    System.err.format("%.1f %% finished.", token.percentFinished());
                    StdOutVisitorHandler.this.lastLineIsProgress = true;
                }
            }
            super.onProgress(token);
        }

        public void onDone(VisitorControlHandler.CompletionCode code, String message) {
            if (StdOutVisitorHandler.this.lastLineIsProgress) {
                System.err.print('\n');
                StdOutVisitorHandler.this.lastLineIsProgress = false;
            }
            if (code != VisitorControlHandler.CompletionCode.SUCCESS) {
                if (code == VisitorControlHandler.CompletionCode.ABORTED) {
                    System.err.println("Visitor aborted: " + message);
                } else if (code == VisitorControlHandler.CompletionCode.TIMEOUT) {
                    System.err.println("Visitor timed out: " + message);
                } else {
                    System.err.println("Visitor aborted due to unknown issue " + code + ": " + message);
                }
            } else if (StdOutVisitorHandler.this.showProgress) {
                System.err.println("Completed visiting.");
            }
            super.onDone(code, message);
        }
    }

    class DataHandler
    extends DumpVisitorDataHandler {
        boolean doStatistics;
        StatisticsMap statisticsMap;
        private volatile boolean first;

        public DataHandler(boolean doStatistics) {
            this.statisticsMap = new StatisticsMap(10000);
            this.first = true;
            this.doStatistics = doStatistics;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message m, AckToken token) {
            if (StdOutVisitorHandler.this.processTimeMilliSecs > 0) {
                try {
                    Thread.sleep(StdOutVisitorHandler.this.processTimeMilliSecs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Object object = StdOutVisitorHandler.this.printLock;
            synchronized (object) {
                if (m instanceof MapVisitorMessage) {
                    this.onMapVisitorData(((MapVisitorMessage)m).getData());
                    this.ack(token);
                } else if (m instanceof DocumentListMessage) {
                    DocumentListMessage dlm = (DocumentListMessage)m;
                    this.onDocumentList(dlm.getBucketId(), dlm.getDocuments());
                    this.ack(token);
                } else if (m instanceof EmptyBucketsMessage) {
                    this.onEmptyBuckets(((EmptyBucketsMessage)m).getBucketIds());
                    this.ack(token);
                } else {
                    super.onMessage(m, token);
                }
            }
        }

        public void onDocument(Document doc, long timestamp) {
            try {
                if (StdOutVisitorHandler.this.lastLineIsProgress) {
                    System.err.print('\r');
                }
                if (StdOutVisitorHandler.this.printIds) {
                    StdOutVisitorHandler.this.out.print(doc.getId());
                    StdOutVisitorHandler.this.out.print(" (Last modified at ");
                    StdOutVisitorHandler.this.out.println(timestamp + ")");
                } else if (StdOutVisitorHandler.this.jsonOutput) {
                    this.writeJsonDocument(doc);
                } else {
                    StdOutVisitorHandler.this.out.print(doc.toXML(StdOutVisitorHandler.this.indentXml ? "  " : ""));
                }
            }
            catch (Exception e) {
                System.err.println("Failed to output document: " + e.getMessage());
                StdOutVisitorHandler.this.getControlHandler().abort();
            }
        }

        private void writeJsonDocument(Document doc) throws IOException {
            this.writeFeedStartOrRecordSeparator();
            StdOutVisitorHandler.this.out.write(JsonWriter.toByteArray((Document)doc));
        }

        public void onRemove(DocumentId docId) {
            try {
                if (StdOutVisitorHandler.this.lastLineIsProgress) {
                    System.err.print('\r');
                }
                if (StdOutVisitorHandler.this.printIds) {
                    StdOutVisitorHandler.this.out.println(docId + " (Removed)");
                } else if (StdOutVisitorHandler.this.jsonOutput) {
                    this.writeJsonDocumentRemove(docId);
                } else {
                    XmlStream stream = new XmlStream();
                    stream.beginTag("remove");
                    stream.addAttribute("documentid", (Object)docId);
                    stream.endTag();
                    assert (stream.isFinalized());
                    StdOutVisitorHandler.this.out.print(stream);
                }
            }
            catch (Exception e) {
                System.err.println("Failed to output document: " + e.getMessage());
                StdOutVisitorHandler.this.getControlHandler().abort();
            }
        }

        private void writeJsonDocumentRemove(DocumentId docId) throws IOException {
            this.writeFeedStartOrRecordSeparator();
            StdOutVisitorHandler.this.out.write(JsonWriter.documentRemove((DocumentId)docId));
        }

        private void writeFeedStartOrRecordSeparator() {
            if (this.first) {
                StdOutVisitorHandler.this.out.println("[");
                this.first = false;
            } else {
                StdOutVisitorHandler.this.out.println(",");
            }
        }

        private void writeFeedEnd() {
            StdOutVisitorHandler.this.out.println("]");
        }

        public void onMapVisitorData(Map<String, String> data) {
            for (String key : data.keySet()) {
                if (this.doStatistics) {
                    Integer i = (Integer)this.statisticsMap.get(key);
                    if (i != null) {
                        this.statisticsMap.put(key, Integer.parseInt(data.get(key)) + i);
                        continue;
                    }
                    this.statisticsMap.put(key, Integer.parseInt(data.get(key)));
                    continue;
                }
                StdOutVisitorHandler.this.out.println(key + ":" + data.get(key));
            }
        }

        public void onDocumentList(BucketId bucketId, List<DocumentListEntry> documents) {
            StdOutVisitorHandler.this.out.println("Got document list of bucket " + bucketId.toString());
            for (DocumentListEntry entry : documents) {
                entry.getDocument().setLastModified(Long.valueOf(entry.getTimestamp()));
                this.onDocument(entry.getDocument(), entry.getTimestamp());
            }
        }

        public void onEmptyBuckets(List<BucketId> bucketIds) {
            StringBuilder buckets = new StringBuilder();
            for (BucketId bid : bucketIds) {
                buckets.append(" ");
                buckets.append(bid.toString());
            }
            log.log(LogLevel.INFO, "Got EmptyBuckets: " + buckets);
        }

        public synchronized void onDone() {
            if (StdOutVisitorHandler.this.jsonOutput) {
                this.writeFeedEnd();
            }
            this.statisticsMap.dumpAll();
            super.onDone();
        }
    }

    class StatisticsMap
    extends LinkedHashMap<String, Integer> {
        int maxSize;

        StatisticsMap(int maxSize) {
            super(100, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Integer> eldest) {
            if (this.size() > this.maxSize) {
                this.dump(eldest);
                return true;
            }
            return false;
        }

        private void dump(Map.Entry<String, Integer> e) {
            StdOutVisitorHandler.this.out.println(e.getKey() + ":" + e.getValue());
        }

        public void dumpAll() {
            for (Map.Entry<String, Integer> entry : this.entrySet()) {
                this.dump(entry);
            }
            this.clear();
        }
    }
}

