/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.documentapi.messagebus.MessageBusDocumentAccess;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.feedapi.SendSession;
import com.yahoo.feedapi.SessionFactory;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Result;
import com.yahoo.messagebus.SourceSession;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;

public class MessageBusSessionFactory
implements SessionFactory {
    private final MessageBusDocumentAccess access;
    private final MessagePropertyProcessor processor;

    public MessageBusSessionFactory(MessagePropertyProcessor processor) {
        this(processor, null, null);
    }

    private MessageBusSessionFactory(MessagePropertyProcessor processor, DocumentmanagerConfig documentmanagerConfig, SlobroksConfig slobroksConfig) {
        this.processor = processor;
        MessageBusParams params = new MessageBusParams();
        params.setTraceLevel(processor.getFeederOptions().getTraceLevel());
        RPCNetworkParams rpcNetworkParams = processor.getFeederOptions().getNetworkParams();
        if (slobroksConfig != null) {
            rpcNetworkParams.setSlobroksConfig(slobroksConfig);
        }
        params.setRPCNetworkParams(rpcNetworkParams);
        params.setDocumentManagerConfigId("client");
        if (documentmanagerConfig != null) {
            params.setDocumentmanagerConfig(documentmanagerConfig);
        }
        this.access = new MessageBusDocumentAccess(params);
    }

    public MessageBusDocumentAccess getAccess() {
        return this.access;
    }

    @Override
    public synchronized SendSession createSendSession(ReplyHandler handler) {
        return new SourceSessionWrapper(this.access.getMessageBus().createSourceSession(handler, this.processor.getFeederOptions().toSourceSessionParams()));
    }

    public void shutDown() {
        this.access.shutdown();
    }

    private class SourceSessionWrapper
    extends SendSession {
        private final SourceSession session;

        private SourceSessionWrapper(SourceSession session) {
            this.session = session;
        }

        @Override
        protected Result onSend(Message m, boolean blockIfQueueFull) throws InterruptedException {
            if (blockIfQueueFull) {
                return this.session.sendBlocking(m);
            }
            return this.session.send(m);
        }

        @Override
        public void close() {
            this.session.close();
        }
    }
}

