/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.document.Document;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.feedapi.SendSession;
import com.yahoo.feedapi.SessionFactory;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Result;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class DummySessionFactory
implements SessionFactory {
    public final List<Message> messages;
    private boolean autoReply;
    private OutputStream output = null;

    private DummySessionFactory(boolean autoReply) {
        this.autoReply = autoReply;
        this.messages = new ArrayList<Message>();
    }

    public static DummySessionFactory createWithAutoReply() {
        return new DummySessionFactory(true);
    }

    public DummySessionFactory(OutputStream out) {
        this.messages = null;
        this.autoReply = true;
        this.output = out;
    }

    private void add(Message m) {
        if (this.messages != null) {
            this.messages.add(m);
        }
    }

    @Override
    public SendSession createSendSession(ReplyHandler r) {
        if (this.output != null) {
            return new DumpDocuments(this.output, r, this);
        }
        if (this.autoReply) {
            return new AutoReplySession(r, null, null, this);
        }
        return new DummySession(r, this);
    }

    private class DumpDocuments
    extends AutoReplySession {
        final OutputStream out;

        DumpDocuments(OutputStream out, ReplyHandler r, DummySessionFactory factory) {
            super(r, null, null, factory);
            this.out = out;
        }

        @Override
        protected void handleMessage(Message m) {
            if (m instanceof PutDocumentMessage) {
                PutDocumentMessage p = (PutDocumentMessage)m;
                Document d = p.getDocumentPut().getDocument();
                d.serialize(this.out);
            }
        }
    }

    private class AutoReplySession
    extends SendSession {
        ReplyHandler handler;
        ReplyFactory replyFactory;
        Error e;
        DummySessionFactory owner;

        AutoReplySession(ReplyHandler handler, ReplyFactory replyFactory, Error e, DummySessionFactory owner) {
            this.handler = handler;
            this.replyFactory = replyFactory;
            this.e = e;
            this.owner = owner;
        }

        protected void handleMessage(Message m) {
        }

        @Override
        protected Result onSend(Message m, boolean blockIfQueueFull) {
            this.owner.add(m);
            this.handleMessage(m);
            Object r = this.replyFactory == null ? new EmptyReply() : this.replyFactory.createReply(m);
            m.setTimeReceivedNow();
            r.setMessage(m);
            r.setContext(m.getContext());
            if (this.e != null) {
                r.addError(this.e);
            }
            this.handler.handleReply((Reply)r);
            return Result.ACCEPTED;
        }

        @Override
        public void close() {
        }
    }

    public static interface ReplyFactory {
        public Reply createReply(Message var1);
    }

    private class DummySession
    extends SendSession {
        ReplyHandler handler;
        DummySessionFactory owner;

        DummySession(ReplyHandler handler, DummySessionFactory owner) {
            this.handler = handler;
            this.owner = owner;
        }

        @Override
        protected Result onSend(Message m, boolean blockIfQueueFull) {
            m.setContext((Object)new MyContext(this.handler, m.getContext()));
            this.owner.add(m);
            return Result.ACCEPTED;
        }

        @Override
        public void close() {
        }
    }

    private class MyContext {
        ReplyHandler handler;
        Object oldContext;

        MyContext(ReplyHandler handler, Object ctxt) {
            this.handler = handler;
            this.oldContext = ctxt;
        }
    }
}

