/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedhandler;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.feedapi.FeedContext;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.feedapi.SharedSender;
import com.yahoo.search.query.ParameterParser;
import java.io.InputStream;

public abstract class VespaFeedHandlerBase {
    protected FeedContext context;
    private final long defaultTimeoutMillis;

    VespaFeedHandlerBase(FeedContext context) {
        this(context, context.getPropertyProcessor().getDefaultTimeoutMillis());
    }

    private VespaFeedHandlerBase(FeedContext context, long defaultTimeoutMillis) {
        this.context = context;
        this.defaultTimeoutMillis = defaultTimeoutMillis;
    }

    SharedSender getSharedSender(String route) {
        return this.context.getSharedSender(route);
    }

    MessagePropertyProcessor getPropertyProcessor() {
        return this.context.getPropertyProcessor();
    }

    InputStream getRequestInputStream(HttpRequest request) {
        return request.getData();
    }

    protected DocumentTypeManager getDocumentTypeManager() {
        return this.context.getDocumentTypeManager();
    }

    protected long getTimeoutMillis(HttpRequest request) {
        return ParameterParser.asMilliSeconds((Object)request.getProperty("timeout"), (Long)this.defaultTimeoutMillis);
    }
}

