/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.feedapi.MessageProcessor;
import com.yahoo.feedapi.SharedSender;
import com.yahoo.feedapi.SimpleFeedAccess;
import com.yahoo.messagebus.Message;
import java.util.ArrayList;
import java.util.List;

public class SingleSender
implements SimpleFeedAccess {
    private final SharedSender.ResultCallback owner;
    private final SharedSender sender;
    private final List<MessageProcessor> messageProcessors = new ArrayList<MessageProcessor>();

    public SingleSender(SharedSender.ResultCallback owner, SharedSender sender) {
        this.owner = owner;
        this.sender = sender;
    }

    @Override
    public void put(Document doc) {
        this.send((Message)new PutDocumentMessage(new DocumentPut(doc)));
    }

    @Override
    public void remove(DocumentId docId) {
        this.send((Message)new RemoveDocumentMessage(docId));
    }

    @Override
    public void update(DocumentUpdate update) {
        this.send((Message)new UpdateDocumentMessage(update));
    }

    @Override
    public void put(Document doc, TestAndSetCondition condition) {
        PutDocumentMessage message = new PutDocumentMessage(new DocumentPut(doc));
        message.setCondition(condition);
        this.send((Message)message);
    }

    @Override
    public void remove(DocumentId docId, TestAndSetCondition condition) {
        RemoveDocumentMessage message = new RemoveDocumentMessage(docId);
        message.setCondition(condition);
        this.send((Message)message);
    }

    @Override
    public void update(DocumentUpdate update, TestAndSetCondition condition) {
        UpdateDocumentMessage message = new UpdateDocumentMessage(update);
        message.setCondition(condition);
        this.send((Message)message);
    }

    @Override
    public boolean isAborted() {
        return this.owner.isAborted();
    }

    public void addMessageProcessor(MessageProcessor processor) {
        this.messageProcessors.add(processor);
    }

    private Message processMessage(Message m) {
        for (MessageProcessor processor : this.messageProcessors) {
            processor.process(m);
        }
        return m;
    }

    public void send(Message m) {
        this.sender.send(this.processMessage(m), this.owner, true);
    }

    public void done() {
    }

    public boolean waitForPending(long timeoutMs) {
        return this.sender.waitForPending(this.owner, timeoutMs);
    }

    @Override
    public void close() {
    }
}

